﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Module;
using VIZ.TVP.Golf.Module;

namespace VIZ.TVP.Golf
{
    /// <summary>
    /// App.xaml 的交互逻辑
    /// </summary>
    public partial class App : Application
    {
        public App()
        {
            // 初始化 LiteDB
            AppSetup.AppendSetup(new AppSetup_InitLiteDB());
            // 初始化 包装资源
            AppSetup.AppendSetup(new AppSetup_InitResource());
            // 初始化 清理远程数据
            AppSetup.AppendSetup(new AppSetup_ClearLocalData());

            // 启动
            AppSetupContext context = AppSetup.Setup();

            if (context.Exception != null)
            {
                MessageBox.Show($"执行 {context.ProviderDetail} 失败\r\n{context.Exception.Message}");
            }

            if (!context.IsSuccess)
            {
                Environment.Exit(-1);
            }
        }
    }
}
