﻿using DevExpress.Xpf.Grid;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;
using VIZ.TVP.Domain;

namespace VIZ.TVP.Common
{
    /// <summary>
    /// 资源拖拽面板
    /// </summary>
    public class ResourceDragBorder : Border
    {
        protected override void OnPreviewMouseLeftButtonDown(MouseButtonEventArgs e)
        {
            base.OnPreviewMouseLeftButtonDown(e);

            CardData cardData = this.DataContext as CardData;
            if (cardData == null)
                return;

            IResourceDrag drag = cardData.Row as IResourceDrag;
            if (drag == null)
                return;

            ResourceDragData data = new ResourceDragData();
            data.FileType = drag.FileType;
            data.ResourcePath = drag.ResourcePath;

            DragDrop.DoDragDrop(this, data, DragDropEffects.Move);
        }
    }
}
