﻿using DevExpress.Xpf.Core;
using DevExpress.Xpf.Editors;
using DevExpress.Xpf.Grid;
using System;
using System.Collections;
using System.Collections.Generic;
using System.Dynamic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using VIZ.TVP.Domain;

namespace VIZ.TVP.Common
{
    /// <summary>
    /// 拖拽停靠文本编辑器
    /// </summary>
    public class DropTextEdit : TextEdit
    {
        public DropTextEdit()
        {
            this.AllowDrop = true;
        }

        protected override void OnPreviewDrop(DragEventArgs e)
        {
            base.OnPreviewDrop(e);

            if (!e.Data.GetDataPresent(typeof(ResourceDragData)))
                return;

            ResourceDragData data = e.Data.GetData(typeof(ResourceDragData)) as ResourceDragData;
            if (data == null)
                return;

            EditGridCellData cellData = this.DataContext as EditGridCellData;
            if (cellData == null)
                return;

            // 控制对象字段
            if (cellData.Row is VizControlObjectFieldModel)
            {
                VizControlObjectFieldModel fieldModel = cellData.Row as VizControlObjectFieldModel;
                fieldModel.Value = data.ResourcePath;
            }

            // 动态数据
            if (cellData.Row is ExpandoObject)
            {
                IDictionary<string, object> dic = cellData.Row as IDictionary<string, object>;
                dic[cellData.Column.FieldName] = data.ResourcePath;
            }
        }
    }
}
