﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using DevExpress.Xpf.Editors.Settings;
using DevExpress.Xpf.Grid;

namespace VIZ.TVP.Domain
{
    /// <summary>
    /// DEV控件列定义对象
    /// </summary>
    public class GridColumnDefinition
    {
        /// <summary>
        /// DEV控件列定义对象
        /// </summary>
        public GridColumnDefinition()
        {
            Width = new GridColumnWidth(1, GridColumnUnitType.Star);
        }

        /// <summary>
        /// 绑定字段
        /// </summary>
        public string FieldName { get; set; }

        /// <summary>
        /// 行数据模板
        /// </summary>
        public DataTemplate CellEditTemplate { get; set; }

        /// <summary>
        /// 宽度
        /// </summary>
        public GridColumnWidth Width { get; set; }

        /// <summary>
        /// 最小宽度
        /// </summary>
        public double MinWidth { get; set; } = 120;

        /// <summary>
        /// 头部
        /// </summary>
        public object Header { get; set; }

        /// <summary>
        /// 是否只读
        /// </summary>
        public bool ReadOnly { get; set; }
    }
}
