﻿using DevExpress.Mvvm.POCO;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Dynamic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.TVP.Domain;
using VIZ.TVP.Service;
using VIZ.TVP.Storage;

namespace VIZ.TVP.Module
{
    /// <summary>
    /// 控制对象支持
    /// </summary>
    public interface IControlObjectSupport
    {
        /// <summary>
        /// 是否正在加载
        /// </summary>
        bool IsLoading { get; set; }

        /// <summary>
        /// 控制对象列表
        /// </summary>
        ObservableCollection<VizControlObjectModel> ControlObjectList { get; set; }

        /// <summary>
        /// 当前选中的控制对象
        /// </summary>
        VizControlObjectModel SelectedControlObject { get; set; }

        /// <summary>
        /// 当前选中的控制对象字段
        /// </summary>
        VizControlObjectFieldModel SelectedControlObjectField { get; set; }

        /// <summary>
        /// List类型数据列表
        /// </summary>
        List<ExpandoObject> ListValue { get; set; }

        /// <summary>
        /// List类型数据列信息
        /// </summary>
        List<GridColumnDefinition> ListValueColumns { get; set; }
    }
}
