﻿using DevExpress.Xpf.Core;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Security.Cryptography;
using System.Text;
using System.Threading.Tasks;
using VIZ.TVP.Domain;

namespace VIZ.TVP.Module
{
    /// <summary>
    /// 项目控制器
    /// </summary>
    public class ProjectController
    {
        /// <summary>
        /// 项目控制器
        /// </summary>
        /// <param name="support">支持</param>
        public ProjectController(IProjectSupport support)
        {
            this.Support = support;
        }

        /// <summary>
        /// 支持
        /// </summary>
        public IProjectSupport Support { get; private set; }

        /// <summary>
        /// 创建项目
        /// </summary>
        public void CreateProject()
        {
            if (ApplicationDomainEx.CurrentProjectDomain != null)
            {
                var result = DXMessageBox.Show("是否保存当前项目", "提示", System.Windows.MessageBoxButton.YesNo);

                if (result == System.Windows.MessageBoxResult.Yes)
                {
                    this.SaveProject();
                }
            }

            CreateProjectWindow window = new CreateProjectWindow();
            window.Owner = this.Support.GetWindow();
            window.ShowDialog();

            CreateProjectViewModel vm = window.createProjectView.DataContext as CreateProjectViewModel;
            if (vm == null || !vm.IsEnter)
                return;

            if (!System.IO.Directory.Exists(vm.ProjectPath))
            {
                System.IO.Directory.CreateDirectory(vm.ProjectPath);
            }
            string path = System.IO.Path.Combine(vm.ProjectPath, $"{vm.ProjectName}{ApplicationConstants.PROJECT_FILE_SUFFIX}");

            ProjectDomain domain = new ProjectDomain();
            domain.ProjectFilePath = path;
            domain.ProjectName = System.IO.Path.GetFileNameWithoutExtension(path);
            domain.ProjectContext = new Storage.ProjectContext(path);

            ProjectChangedMessage msg = new ProjectChangedMessage();
            msg.OldProjectDomain = ApplicationDomainEx.CurrentProjectDomain;
            msg.NewProjectDomain = domain;

            ApplicationDomainEx.CurrentProjectDomain = domain;
            this.Support.ProjectName = domain.ProjectName;

            // 发送项目创建消息
            ApplicationDomainEx.MessageManager.Send(msg);

            // 更新命令状态
            this.Support.UpdateCommandStatus();
        }

        /// <summary>
        /// 打开项目
        /// </summary>
        public void OpenProject()
        {
            // 关闭当前项目
            this.CloseProject();

            System.Windows.Forms.OpenFileDialog ofd = new System.Windows.Forms.OpenFileDialog();
            ofd.Filter = "播控项目文件|*.viz_tvp";
            ofd.Multiselect = false;
            ofd.InitialDirectory = System.IO.Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "projects");

            if (ofd.ShowDialog() != System.Windows.Forms.DialogResult.OK)
                return;

            ProjectDomain domain = new ProjectDomain();
            domain.ProjectFilePath = ofd.FileName;
            domain.ProjectName = System.IO.Path.GetFileNameWithoutExtension(ofd.FileName);
            domain.ProjectContext = new Storage.ProjectContext(ofd.FileName);

            ProjectChangedMessage msg = new ProjectChangedMessage();
            msg.OldProjectDomain = ApplicationDomainEx.CurrentProjectDomain;
            msg.NewProjectDomain = domain;

            ApplicationDomainEx.CurrentProjectDomain = domain;
            this.Support.ProjectName = domain.ProjectName;

            // 发送项目创建消息
            ApplicationDomainEx.MessageManager.Send(msg);

            // 更新命令状态
            this.Support.UpdateCommandStatus();
        }

        /// <summary>
        /// 保存项目
        /// </summary>
        public void SaveProject()
        {
            if (ApplicationDomainEx.CurrentProjectDomain == null)
                return;

            ProjectSaveMessage msg = new ProjectSaveMessage();
            msg.ProjectDomain = ApplicationDomainEx.CurrentProjectDomain;

            ApplicationDomainEx.MessageManager.Send(msg);

            // 更新命令状态
            this.Support.UpdateCommandStatus();
        }

        /// <summary>
        /// 另存为
        /// </summary>
        public void SaveAsProject()
        {
            if (ApplicationDomainEx.CurrentProjectDomain == null)
                return;

            System.Windows.Forms.SaveFileDialog sfd = new System.Windows.Forms.SaveFileDialog();
            sfd.Filter = "播控项目文件|*.viz_tvp";
            if (sfd.ShowDialog() != System.Windows.Forms.DialogResult.OK)
                return;

            ProjectDomain domain = new ProjectDomain();
            domain.ProjectFilePath = sfd.FileName;
            domain.ProjectName = System.IO.Path.GetFileNameWithoutExtension(sfd.FileName);
            domain.ProjectContext = new Storage.ProjectContext(sfd.FileName);

            ApplicationDomainEx.CurrentProjectDomain = domain;
            this.Support.ProjectName = domain.ProjectName;

            ProjectSaveMessage msg = new ProjectSaveMessage();
            msg.ProjectDomain = ApplicationDomainEx.CurrentProjectDomain;

            ApplicationDomainEx.MessageManager.Send(msg);

            // 更新命令状态
            this.Support.UpdateCommandStatus();
        }

        /// <summary>
        /// 关闭项目
        /// </summary>
        public void CloseProject()
        {
            if (ApplicationDomainEx.CurrentProjectDomain == null)
                return;

            if (DXMessageBox.Show("是否保存项目", "提示", System.Windows.MessageBoxButton.YesNo) == System.Windows.MessageBoxResult.Yes)
            {
                this.SaveProject();
            }

            ApplicationDomainEx.CurrentProjectDomain.Dispose();

            ProjectChangedMessage msg = new ProjectChangedMessage();
            msg.OldProjectDomain = ApplicationDomainEx.CurrentProjectDomain;
            msg.NewProjectDomain = null;

            ApplicationDomainEx.MessageManager.Send(msg);
            ApplicationDomainEx.CurrentProjectDomain = null;
            this.Support.ProjectName = null;

            // 更新命令状态
            this.Support.UpdateCommandStatus();
        }
    }
}
