﻿using DevExpress.Data.XtraReports.Native;
using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web.UI.WebControls;
using System.Windows;
using VIZ.Framework.Core;
using VIZ.Framework.Plugin;
using VIZ.TVP.Domain;

namespace VIZ.TVP.Module
{
    /// <summary>
    /// 主视图模型
    /// </summary>
    public class MainViewModel : ViewModelBase, IMainViewService
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static readonly ILog log = LogManager.GetLogger(typeof(MainViewModel));

        public MainViewModel()
        {
            // 包含视图的插件
            this.ItemsSource = ApplicationDomainEx.PluginManager.Plugins.Where(p => p.HasView).ToObservableCollection();

            //
            // 注册服务
            ApplicationDomainEx.ServiceManager.AddService(ServiceKeys.MAIN_VIEW_SERVICE, this);
        }

        #region ItemsSource -- 视图项

        private ObservableCollection<PluginInfo> itemsSource;
        /// <summary>
        /// 视图项
        /// </summary>
        public ObservableCollection<PluginInfo> ItemsSource
        {
            get { return itemsSource; }
            set { itemsSource = value; this.RaisePropertyChanged(nameof(ItemsSource)); }
        }

        #endregion

        /// <summary>
        /// 保存布局
        /// </summary>
        public void SaveLayout()
        {
            MainView view = this.GetView<MainView>();
            if (view == null)
                return;

            string path = System.IO.Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "layout.xml");
            view.dockLayoutManager.SaveLayoutToXml(path);
        }

        /// <summary>
        /// 加载布局
        /// </summary>
        public void LoadLayout()
        {
            MainView view = this.GetView<MainView>();
            if (view == null)
                return;

            string path = System.IO.Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "layout.xml");
            view.dockLayoutManager.RestoreLayoutFromXml(path);
        }
    }
}
