﻿using DevExpress.Printing.Core.PdfExport.Metafile;
using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web;
using VIZ.Framework.Core;
using VIZ.TVP.Domain;

namespace VIZ.TVP.Module
{
    public class LocalResourceFileController
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static readonly ILog log = LogManager.GetLogger(typeof(VizResourceFileController));

        /// <summary>
        /// VIZ资源缩略图控制器
        /// </summary>
        /// <param name="support">支持</param>
        public LocalResourceFileController(ILocalResourceFileSupport support)
        {
            this.Support = support;
        }

        /// <summary>
        /// 支持
        /// </summary>
        public ILocalResourceFileSupport Support { get; private set; }



        /// <summary>
        /// 更新文件模型
        /// </summary>
        /// <param name="folder">文件夹</param>
        public void UpdateFileModels(GHResourceFolderModel folder)
        {
            //FolderModels = new ObservableCollection<LFResourceFolderModel>();
            //FolderModels = tempfolderModel;
            //SelectedFolderModel = tempSelecFolder;

            if (folder == null) return;
            ObservableCollection<GHResourceFileModel> ImgeFile = new ObservableCollection<GHResourceFileModel>();

            //Task.Run(() =>
            //{
                if (folder.Files != null)
                {
                    foreach (var fileModel in folder.Files)
                    {
                        if (ThumbnailHelper.IsImage(fileModel.Path))
                        {
                            // D:\世界杯单独项目\竖屏世界杯包装效果\VAR团队名单.jpg

                            WPFHelper.BeginInvoke(() =>
                            {


                                Image image = ThumbnailHelper.GetImage(fileModel.Path, 100, 200);
                                Bitmap btm = new Bitmap(image);
                                fileModel.ThumbnailBitmap = btm;
                                fileModel.FileType = ResourceFileType.IMAGE;
                                ImgeFile.Add(fileModel);

                            });
                        }
                        else if (ThumbnailHelper.IsVideo(fileModel.Path))
                        {
                            string strVedioPath = string.Format("{0}{1}", System.Environment.CurrentDirectory, "\\VedioImage\\Vedio.jpeg");

                            Image vedioImage = Image.FromFile(strVedioPath);

                            Bitmap vedioBtm = new Bitmap(vedioImage);
                            fileModel.ThumbnailBitmap = vedioBtm;
                            fileModel.FileType = ResourceFileType.Video;
                            ImgeFile.Add(fileModel);
                        }
                    }
                    this.Support.FileModels = ImgeFile;

                }
            //});
          

         
        }


 


        /// <summary>
        /// 销毁文件模型
        /// </summary>
        public void DisposeFileModels(GHResourceFolderModel folder)
        {
            if (folder == null || folder.Files == null || folder.Files.Count == 0)
                return;

            foreach (GHResourceFileModel file in folder.Files)
            {
                file.Dispose();
            }
        }

    }
}
