﻿using DevExpress.Utils.Filtering.Internal;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;


namespace VIZ.TVP.Module
{

    public class ThumbnailHelper
    {
        /// <summary>
        /// 生成高清缩略图片方法
        /// </summary>
        /// <param name="image"></param>
        /// <param name="width"></param>
        /// <param name="height"></param>
        /// <returns></returns>
        public static Image GetThumbnail(Image image, int width, int height)
        {
            Bitmap bmp = new Bitmap(width, height);
            //从Bitmap创建一个System.Drawing.Graphics
            System.Drawing.Graphics gr = System.Drawing.Graphics.FromImage(bmp);
            //设置 
            gr.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.HighQuality;
            //下面这个也设成高质量
            gr.CompositingQuality = System.Drawing.Drawing2D.CompositingQuality.HighQuality;
            //下面这个设成High
            gr.InterpolationMode = System.Drawing.Drawing2D.InterpolationMode.HighQualityBicubic;
            //把原始图像绘制成上面所设置宽高的缩小图
            System.Drawing.Rectangle rectDestination = new Rectangle(0, 0, width, height);

            gr.DrawImage(image, rectDestination, 0, 0, image.Width, image.Height, GraphicsUnit.Pixel);
            return bmp;
        }

        /// <summary>
        /// 获取图片
        /// </summary>
        /// <param name="path"></param>
        /// <param name="width"></param>
        /// <param name="height"></param>
        /// <returns></returns>
        public static Image GetImage(string path, int width, int height)
        {
            try
            {
                //string newPath = "";
                //if (File.Exists(Application.StartupPath + path))
                //{
                //    newPath = Application.StartupPath + path;
                //}
                //else
                //{//如果图片不存在，使用默认图片
                // //newPath = Application.StartupPath + LocalConfig.defaultPicPath;
                //}
                FileStream fs = new FileStream(path, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                Image result = Image.FromStream(fs);
                fs.Close();
                result = GetThumbnail(result, width, height);
                return result;
            }
            catch (Exception e)
            {
                return null;
            }
        }

        #region ---图片文件检测

        public static Boolean IsImage(string path)
        {
            try
            {
                if (IsImageByName(path))
                {
                    System.Drawing.Image img = System.Drawing.Image.FromFile(path);
                    return true;
                }
                return false;
            }
            catch (Exception e)
            {
                return false;
            }
        }
        private static Boolean IsImageByName(string name)
        {
            int pos = name.LastIndexOf(".");
            if (name.Length - pos - 1 < 3)
                return false;

            string ext = name.Substring(pos + 1, name.Length - pos - 1);
            string[] imge = { "jpg", "jpeg", "png", "gif", "bmp", "TIFF", "tif" };

            return IsInIgnoreCase(ext, imge);
        }

        private static bool IsInIgnoreCase(string source, params string[] list)
        {
            if (null == source) return false;

            IEnumerable<string> en = list.Where(i => string.Compare(i, source, StringComparison.OrdinalIgnoreCase) == 0);
            return en.Count() == 0 ? false : true;
        }
        /// <summary>
        /// 读取图片文件
        /// </summary>
        /// <param name="path">图片文件路径</param>
        /// <returns>图片文件</returns>
        private Bitmap ReadImageFile(String path)
        {
            Bitmap bitmap = null;
            try
            {
                FileStream fileStream = File.OpenRead(path);
                Int32 filelength = 0;
                filelength = (int)fileStream.Length;
                Byte[] image = new Byte[filelength];
                fileStream.Read(image, 0, filelength);
                System.Drawing.Image result = System.Drawing.Image.FromStream(fileStream);
                fileStream.Close();
                bitmap = new Bitmap(result);
            }
            catch (Exception ex)
            {
                //  异常输出
            }
            return bitmap;
        }

        /// <summary>
        /// 是否是视频
        /// </summary>
        /// <param name="filePath"></param>
        /// <returns></returns>
        public static bool IsVideo(string filePath)
        {
            bool isVideo = false;
            string fileName = filePath;
            IList<string> formateList = new List<string> {
               "avi","flv","mpg","mpeg","mpe","m1v","m2v","mpv2","mp2v","dat","ts","tp","tpr","pva","pss","mp4","m4v",
                "m4p","m4b","3gp","3gpp","3g2","3gp2","ogg","mov","qt","amr","rm","ram","rmvb","rpm"};

            string[] Namesuffix = fileName.Split('.');

            if (Namesuffix.Length > 1)
            {
                if (formateList.Contains(Namesuffix[1]))
                {
                    isVideo = true;
                }
            }

            return isVideo;
        }

        #endregion




    }
}
