﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.TVP.Domain;

namespace VIZ.TVP.Module
{
    public interface IMediaResourceFileSupport
    {
        /// <summary>
        /// 文件夹目录集合
        /// </summary>
        ObservableCollection<GHResourceFolderModel> FolderModels { get; set; }

        /// <summary>
        /// 当前选中的文件夹
        /// </summary>
        GHResourceFolderModel SelectedFolderModel { get; set; }

        /// <summary>
        /// 文件集合
        /// </summary>
        ObservableCollection<GHResourceFileModel> FileModels { get; set; }

        /// <summary>
        /// 选中的文件模型
        /// </summary>
        GHResourceFileModel SelectedFileModel { get; set; }

        /// <summary>
        /// 是否正在加载文件
        /// </summary>
        bool IsFileLoading { get; set; }
    }
}
