﻿using log4net;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Drawing.Imaging;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.TVP.Domain;
using VIZ.TVP.Service;
using VIZ.TVP.Storage;

namespace VIZ.TVP.Module
{
    public class MediaResourceFileController
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static readonly ILog log = LogManager.GetLogger(typeof(VizResourceFileController));

        /// <summary>
        /// VIZ资源缩略图控制器
        /// </summary>
        /// <param name="support">支持</param>
        public MediaResourceFileController(IMediaResourceFileSupport support)
        {
            this.Support = support;
        }

        /// <summary>
        /// 支持
        /// </summary>
        public IMediaResourceFileSupport Support { get; private set; }

        /// <summary>
        /// GH 资源服务
        /// </summary>
        private IGHResourceService ghResourceService = new GHResourceService();

        /// <summary>
        /// GH 服务
        /// </summary>
        private IGHService ghService = new GHService();

        /// <summary>
        /// 更新文件模型
        /// </summary>
        /// <param name="folder">文件夹</param>
        public  void UpdateFileModels(GHResourceFolderModel folder)
        {
            // 文件夹对象不存在
            if (folder == null)
            {
                this.Support.FileModels = null;
                this.Support.SelectedFileModel = null;
                return;
            }

            //// 已经获取过文件
            if (folder.IsRefreshedFiles)
            {
                this.Support.FileModels = folder.Files;
                return;
            }

            //GH_Link_Node link_related = folder.EntryNode.links.FirstOrDefault(p => p.rel == GH_Link_Rel_Enums.related);
            //if (link_related == null || string.IsNullOrWhiteSpace(link_related.href))
            //{
            //    folder.IsRefreshedFiles = true;
            //    return;
            //}

            //this.Support.IsFileLoading = true;

            //ThreadHelper.SafeRun(() =>
            //{
            //    List<GHResourceFileModel> files = ghResourceService.GetGHResourceFiles(link_related.href, folder);

            // WPFHelper.BeginInvoke(() =>
            //    {
            //        folder.Files = files.ToObservableCollection();
            //        this.Support.FileModels = folder.Files;
            //        folder.IsRefreshedFiles = true;

            //        this.Support.IsFileLoading = false;

            //        // 开始下载缩略图
            //        this.BeginDownloadThumbnail(folder);
            //    });
            //});
            //



                WPFHelper.BeginInvoke(async () =>
                {

                    string header = string.Format("http://192.168.3.76:9000/api/home/GetListFile?filePath={0}", folder.Path);
                    var FileResult =  await MediaResourceFileService.PostObjectAsync<fileListResult,string>(header,"");

                    List<GHResourceFileModel> list = new List<GHResourceFileModel>();
                   // folder.Files = new System.Collections.ObjectModel.ObservableCollection<GHResourceFileModel>();

                    foreach (var file in FileResult.masterData)
                    {
                        GHResourceFileModel GHFile = new GHResourceFileModel();

                        GHFile.Name = file.fileName;
                        GHFile.Path = file.smallIconUrl;
                        list.Add(GHFile);

                        if(ThumbnailHelper.IsImage(GHFile.Name))
                        {
                            //GetFile

                            string url = string.Format("http://192.168.3.76:9000/api/home/GetFile?filePath={0}", folder.Path);

                           // var r
                        }
                        else if(ThumbnailHelper.IsImage(GHFile.Name))
                        {

                        }
                    }
                });

     





        }



        public async Task<List<GHResourceFolderModel>> GetMeiaResourceFolder()
        {
            var folderResult =  await MediaResourceFileService.PostObjectAsync<fileListResult, string>("http://192.168.3.76:9000/api/home/GetListFiles", "");

            if (folderResult == null)
                return null;
       
            return GetFolder(folderResult.masterData);
        }



        private List<GHResourceFolderModel> GetFolder(List<ms> foldersDatas)
        {
            List<GHResourceFolderModel> listFolderModel = new List<GHResourceFolderModel>();

            foreach(var floderData in foldersDatas)
            {
                if(floderData.fileType== "floder")
                {
                    GHResourceFolderModel child = new GHResourceFolderModel();
                    child.Name = floderData.fileName;
                    child.FolderType = ResourceFolderType.Folder;
                    child.Path = floderData.smallIconUrl;

                    List<GHResourceFolderModel> children_list = GetFolder(floderData.m);


                    foreach (GHResourceFolderModel item in children_list)
                    {

                        child.Children.Add(item);
                        item.Parent = child;
                    }

                    listFolderModel.Add(child);
                }

            }

            return listFolderModel;
        }

       


        /// <summary>
        /// 开始下载缩略图
        /// </summary>
        /// <param name="folder">文件夹</param>
        public void BeginDownloadThumbnail(GHResourceFolderModel folder)
        {
            if (folder == null || folder.Files == null || folder.Files.Count == 0)
                return;

            ThreadHelper.SafeRun(() =>
            {
                foreach (GHResourceFileModel file in folder.Files)
                {
                    this.DownloadThumbnail(file);
                }
            });
        }

        /// <summary>
        /// 开始下载缩略图
        /// </summary>
        /// <param name="file">文件</param>
        public void DownloadThumbnail(GHResourceFileModel file)
        {
            if (file == null || string.IsNullOrWhiteSpace(file.Thumbnail))
                return;

            try
            {
                Bitmap bmp = this.ghService.GetImage(file.Thumbnail);

                WPFHelper.BeginInvoke(() =>
                {
                    file.ThumbnailBitmap = bmp;
                });
            }
            catch (Exception ex)
            {
                log.Error(ex);
            }
        }

        /// <summary>
        /// 销毁文件模型
        /// </summary>
        public void DisposeFileModels(GHResourceFolderModel folder)
        {
            if (folder == null || folder.Files == null || folder.Files.Count == 0)
                return;

            foreach (GHResourceFileModel file in folder.Files)
            {
                file.Dispose();
            }
        }
    }
}
