﻿using DevExpress.Mvvm.Native;
using DevExpress.Xpf.Core;
using DevExpress.Xpf.Core.Native;
using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Core;
using VIZ.TVP.Domain;

namespace VIZ.TVP.Module
{
    /// <summary>
    /// 设置视图模型
    /// </summary>
    public class SettingViewModel : ViewModelBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static readonly ILog log = LogManager.GetLogger(typeof(SettingViewModel));

        public SettingViewModel()
        {
            // 初始化命令
            this.initCommand();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void initCommand()
        {
            this.LoadedCommand = new VCommand(this.Loaded);
            this.SaveCommand = new VCommand(this.Save);
        }

        // ======================================================================================
        // Property
        // ======================================================================================

        #region SettingItems -- 设置项集合

        private ObservableCollection<SettingModel> settingItems;
        /// <summary>
        /// 设置项集合
        /// </summary>
        public ObservableCollection<SettingModel> SettingItems
        {
            get { return settingItems; }
            set { settingItems = value; this.RaisePropertyChanged(nameof(SettingItems)); }
        }

        #endregion

        #region SelectedSettingItem -- 当前选中的设置项

        private SettingModel selectedSettingItem;
        /// <summary>
        /// 当前选中的设置项
        /// </summary>
        public SettingModel SelectedSettingItem
        {
            get { return selectedSettingItem; }
            set { selectedSettingItem = value; this.RaisePropertyChanged(nameof(SelectedSettingItem)); }
        }

        #endregion

        // ======================================================================================
        // Command
        // ======================================================================================

        #region LoadedCommand -- 加载命令

        /// <summary>
        /// 加载命令
        /// </summary>
        public VCommand LoadedCommand { get; set; }

        /// <summary>
        /// 加载
        /// </summary>
        private void Loaded()
        {
            ObservableCollection<SettingModel> items = new ObservableCollection<SettingModel>();

            // 加载内置设置页面

            // Viz设置
            SettingModel viz = new SettingModel();
            viz.DisplayName = "Viz设置";
            viz.ViewType = typeof(VizSettingView);
            items.Add(viz);

            // 控制设置
            SettingModel control = new SettingModel();
            control.DisplayName = "控制";
            control.ViewType = typeof(ControlSettingView);
            items.Add(control);

            // 插件设置页面
            foreach (var plugin in ApplicationDomainEx.PluginManager.Plugins)
            {
                if (!plugin.HasSettingView)
                    continue;

                SettingModel model = new SettingModel();
                model.DisplayName = plugin.DisplayName;
                model.ViewType = plugin.SettingViewInfo.ViewType;
                model.ViewModelType = plugin.SettingViewInfo.ViewModelType;

                items.Add(model);
            }

            foreach (var plugin in ApplicationDomainEx.PluginManager.TemplatePlugins)
            {
                if (!plugin.HasSettingView)
                    continue;

                SettingModel model = new SettingModel();
                model.DisplayName = plugin.DisplayName;
                model.ViewType = plugin.SettingViewInfo.ViewType;
                model.ViewModelType = plugin.SettingViewInfo.ViewModelType;

                items.Add(model);
            }

            this.SettingItems = items;
            this.SelectedSettingItem = items.FirstOrDefault();
        }

        #endregion

        #region SaveCommand -- 保存命令

        /// <summary>
        /// 保存命令
        /// </summary>
        public VCommand SaveCommand { get; set; }

        /// <summary>
        /// 保存
        /// </summary>
        private void Save()
        {
            foreach (SettingModel item in this.SettingItems)
            {
                if (item.View == null)
                    continue;

                if (!item.View.TryGetTarget(out object obj))
                    continue;

                FrameworkElement view = obj as FrameworkElement;
                if (view == null)
                    continue;

                ISettingViewModel vm = view.DataContext as ISettingViewModel;
                if (vm == null)
                    continue;

                try
                {
                    vm.Save();
                }
                catch (Exception ex)
                {
                    log.Error(ex);
                }
            }

            DXMessageBox.Show("保存成功！");
        }

        #endregion
    }
}
