﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using log4net;
using VIZ.Framework.Core;
using VIZ.Framework.Domain;
using VIZ.Framework.Connection;
using VIZ.Framework.Storage;
using VIZ.Framework.Module;
using VIZ.TVP.Domain;
using VIZ.TVP.Service;

namespace VIZ.TVP.Module
{
    /// <summary>
    /// 应用程序启动 -- 初始化CSV
    /// </summary>
    public class AppSetup_InitCSV : AppSetupBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog log = LogManager.GetLogger(typeof(AppSetup_InitCSV));

        /// <summary>
        /// 描述
        /// </summary>
        public override string Detail { get; } = "应用程序启动 -- 初始化CSV";

        /// <summary>
        /// 执行启动
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        /// <returns>是否成功执行</returns>
        public override bool Setup(AppSetupContext context)
        {
            ApplicationDomainEx.DataBaseManager.CsvContext = new Storage.CsvContext();

            // 加载插件配置
            this.LoadPluginConfig();

            return true;
        }

        /// <summary>
        /// 加载插件配置
        /// </summary>
        private void LoadPluginConfig()
        {
            string folder = System.IO.Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "config");
            if (!System.IO.Directory.Exists(folder))
            {
                System.IO.Directory.CreateDirectory(folder);
            }

            string path = System.IO.Path.Combine(folder, "plugin_config.csv");

            ApplicationDomainEx.DataBaseManager.CsvContext.LoadPluginConfig(path);
        }



        /// <summary>
        /// 执行关闭
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        public override void Shutdown(AppSetupContext context)
        {

        }
    }
}
