﻿using DevExpress.Xpf.Grid.TreeList;
using log4net;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Framework.Plugin;
using VIZ.TVP.Domain;
using VIZ.TVP.Service;
using VIZ.TVP.Storage;

namespace VIZ.TVP.Module
{
    /// <summary>
    /// 上版视图模型
    /// </summary>
    public class TakeViewModel : PluginViewModelBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private readonly static ILog log = LogManager.GetLogger(typeof(TakeViewModel));

        public TakeViewModel()
        {
            // 初始化命令
            this.initCommand();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void initCommand()
        {
            this.TakeCommand = new VCommand(this.Take);
            this.ContinueCommand = new VCommand(this.Continue);
            this.TakeOutCommand = new VCommand(this.TakeOut);
            this.UpdateCommand = new VCommand(this.Update);
        }

        // ==============================================================
        // Service & Controller
        // ==============================================================

        /// <summary>
        /// Viz引擎命令服务
        /// </summary>
        private IVizCommandService vizCommandService = new VizCommandService();

        /// <summary>
        /// Viz引擎控制对象服务
        /// </summary>
        private IVizCommandControlObjectService VizCommandControlObjectService = new VizCommandControlObjectService();

        // ==============================================================
        // Property
        // ==============================================================

        // ==============================================================
        // Command
        // ==============================================================

        #region TakeCommand -- 上版子命令

        /// <summary>
        /// 上版命令
        /// </summary>
        public VCommand TakeCommand { get; set; }

        /// <summary>
        /// 上板
        /// </summary>
        private void Take()
        {
            IProgramListViewService service = ApplicationDomainEx.ServiceManager.GetService<IProgramListViewService>(ServiceKeys.PROGRAM_LIST_VIEW_SERVICE);
            if (service == null)
                return;

            ProgramListItemModel programListItem = service.GetSelectedProgramListItem();
            if (programListItem == null)
                return;

            var group = ApplicationDomainEx.TVPConnectionManager.ConnectionGroups.FirstOrDefault(p => p.IsEnabled);
            if (group == null)
                return;

            var items = group.Items.Where(p => p.IsEnabled).ToList();

            foreach (var item in items)
            {
                try
                {
                    if (!item.IsConnected)
                        continue;
                    
                    VizControlObjectModel main = programListItem.ControlObjectList.FirstOrDefault();
                    this.vizCommandService.TakeIn(item, programListItem.Path, programListItem.Layer, main?.UseAllDirectors ?? false);
                }
                catch (Exception ex)
                {
                    log.Error(ex);
                }
            }
        }

        #endregion

        #region ContinueCommand -- 继续命令

        /// <summary>
        /// 继续命令
        /// </summary>
        public VCommand ContinueCommand { get; set; }

        /// <summary>
        /// 继续
        /// </summary>
        private void Continue()
        {
            IProgramListViewService service = ApplicationDomainEx.ServiceManager.GetService<IProgramListViewService>(ServiceKeys.PROGRAM_LIST_VIEW_SERVICE);
            if (service == null)
                return;

            ProgramListItemModel programListItem = service.GetSelectedProgramListItem();
            if (programListItem == null)
                return;

            var group = ApplicationDomainEx.TVPConnectionManager.ConnectionGroups.FirstOrDefault(p => p.IsEnabled);
            if (group == null)
                return;

            var items = group.Items.Where(p => p.IsEnabled).ToList();

            foreach (var item in items)
            {
                try
                {
                    if (!item.IsConnected)
                        continue;

                    this.vizCommandService.TakeContinue(item, programListItem.Layer);
                }
                catch (Exception ex)
                {
                    log.Error(ex);
                }
            }
        }

        #endregion

        #region TakeOutCommand -- 下版命令

        /// <summary>
        /// 下版命令
        /// </summary>
        public VCommand TakeOutCommand { get; set; }

        /// <summary>
        /// 下版
        /// </summary>
        private void TakeOut()
        {
            IProgramListViewService service = ApplicationDomainEx.ServiceManager.GetService<IProgramListViewService>(ServiceKeys.PROGRAM_LIST_VIEW_SERVICE);
            if (service == null)
                return;

            ProgramListItemModel programListItem = service.GetSelectedProgramListItem();
            if (programListItem == null)
                return;

            var group = ApplicationDomainEx.TVPConnectionManager.ConnectionGroups.FirstOrDefault(p => p.IsEnabled);
            if (group == null)
                return;

            var items = group.Items.Where(p => p.IsEnabled).ToList();

            foreach (var item in items)
            {
                try
                {
                    if (!item.IsConnected)
                        continue;

                    this.vizCommandService.TakeOut(item, programListItem.Layer);
                }
                catch (Exception ex)
                {
                    log.Error(ex);
                }
            }
        }

        #endregion

        #region UpdateCommand -- 更新命令

        /// <summary>
        /// 更新命令
        /// </summary>
        public VCommand UpdateCommand { get; set; }

        /// <summary>
        /// 更新
        /// </summary>
        private void Update()
        {
            IProgramListViewService service = ApplicationDomainEx.ServiceManager.GetService<IProgramListViewService>(ServiceKeys.PROGRAM_LIST_VIEW_SERVICE);
            if (service == null)
                return;

            ProgramListItemModel programListItem = service.GetSelectedProgramListItem();
            if (programListItem == null)
                return;

            var group = ApplicationDomainEx.TVPConnectionManager.ConnectionGroups.FirstOrDefault(p => p.IsEnabled);
            if (group == null)
                return;

            var items = group.Items.Where(p => p.IsEnabled).ToList();

            foreach (var item in items)
            {
                try
                {
                    if (!item.IsConnected)
                        continue;

                    VizControlObjectModel main = programListItem.ControlObjectList.FirstOrDefault();
                    if (main == null)
                        continue;

                    this.VizCommandControlObjectService.SetControlObjectValue(item, VizSceneLayerEnum.MAIN_SCENE, main);
                }
                catch (Exception ex)
                {
                    log.Error(ex);
                }
            }
        }

        #endregion

        // ==============================================================
        // Public Function
        // ==============================================================

        /// <summary>
        /// 销毁
        /// </summary>
        public override void Dispose()
        {

        }
    }
}
