﻿using DevExpress.Mvvm.Native;
using DevExpress.Printing.StreamingPagination;
using log4net;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.TVP.Connection;
using VIZ.TVP.Domain;
using VIZ.TVP.Storage;

namespace VIZ.TVP.Module
{
    /// <summary>
    /// VIZ控制器
    /// </summary>
    public class VizController
    {
        /// <summary>
        /// 日志
        /// </summary>
        private readonly static ILog log = LogManager.GetLogger(typeof(VizController));

        /// <summary>
        /// VIZ控制器
        /// </summary>
        /// <param name="support">支持</param>
        public VizController(IVizSupport support)
        {
            this.Support = support;
        }

        /// <summary>
        /// 支持
        /// </summary>
        public IVizSupport Support { get; private set; }

        /// <summary>
        /// 启动VIZ引擎
        /// </summary>
        /// <param name="view"></param>
        /// <param name="path">引擎路径</param>
        /// <param name="connectionModel">连接模型</param>
        public void StartVizEngine(VizRenderView view, string path, TVPConnectionModel connectionModel)
        {
            this.Support.IsEngineReady = false;

            var dpi = WPFHelper.GetDpiByGraphics();
            int width = (int)(view.host.ActualWidth * (dpi.X / 96d));
            int height = (int)(view.host.ActualHeight * (dpi.Y / 96d));

            ImageHelper.AdjustSize(width, height, 1920, 1080, out width, out height);

            IntPtr hWnd = view.host.ContainerFormHandle;
            IntPtr vizHandle = IntPtr.Zero;

            ThreadHelper.SafeRun(() =>
            {
                LocalInfoEntity info = ApplicationDomainEx.DataBaseManager.LocalInfo;

                // Step 1. 启动进程
                ApplicationDomainEx.LocalVizManager.VizRenderersProcess = new Process();
                ApplicationDomainEx.LocalVizManager.VizRenderersProcess.StartInfo.WorkingDirectory = System.IO.Path.GetDirectoryName(path);
                ApplicationDomainEx.LocalVizManager.VizRenderersProcess.StartInfo.FileName = System.IO.Path.GetFileName(path);
                //VIZ3:  " -o -P -db Guest:@localhost/VizDbServer:19396"
                //VIZ4:  "-u1 -n -M -e Guest:@localhost/VizDbServer:19396"
                LocalInfoEntity loginInfo = ApplicationDomainEx.DataBaseManager.LocalInfo;

                if (info.LocalEngineType == LocalEngineType.Eng3)
                {
                    ApplicationDomainEx.LocalVizManager.VizRenderersProcess.StartInfo.Arguments = $" -o -P -db {loginInfo.VIZ_UserName}:@{loginInfo.VIZ_IP}/{loginInfo.GH_ServerName}:{loginInfo.GH_Port}";
                }
                if (info.LocalEngineType == LocalEngineType.Eng4)
                {
                    ApplicationDomainEx.LocalVizManager.VizRenderersProcess.StartInfo.Arguments = $" -o -P -db {loginInfo.VIZ_UserName}:@{loginInfo.VIZ_IP}/{loginInfo.GH_ServerName}:{loginInfo.GH_Port}";
                    //this.VizProcess.StartInfo.Arguments = $" -u1 -n -M -e {loginInfo.VIZ_UserName}:@{loginInfo.VIZ_IP}/{loginInfo.GH_ServerName}:{loginInfo.GH_Port}";
                }

                ApplicationDomainEx.LocalVizManager.VizRenderersProcess.StartInfo.UseShellExecute = true;
                ApplicationDomainEx.LocalVizManager.VizRenderersProcess.StartInfo.WindowStyle = ProcessWindowStyle.Normal;
                ApplicationDomainEx.LocalVizManager.VizRenderersProcess.Start();

                // Step 2. 连接VIZ
                do
                {
                    System.Threading.Thread.Sleep(1000);

                } while (!connectionModel.EndpointManager.Connect());

                // Step 3. 发送渲染命令
                do
                {
                    System.Threading.Thread.Sleep(1000);

                    if (info.LocalEngineType == LocalEngineType.Eng3)
                    {
                        string cmd = $"RENDERER WINDOW_OPEN_ON_PARENT 0x{hWnd.ToString("X6")} {width} {height} ONAIR";
                        connectionModel.EndpointManager.Send(cmd);
                    }
                    else if (string.IsNullOrWhiteSpace(ApplicationDomainEx.LocalVizManager.VizRendererName) && info.LocalEngineType == LocalEngineType.Eng4)
                    {
                        // 创建 EDITOR
                        ApplicationDomainEx.LocalVizManager.VizRendererName = connectionModel.EndpointManager.Request("EDITOR CREATE RENDERER");
                        string cmd = $"{ApplicationDomainEx.LocalVizManager.VizRendererName} WINDOW_OPEN_ON_PARENT 0x{hWnd.ToString("X6")} {width} {height} ONAIR";
                        connectionModel.EndpointManager.Send(cmd);
                    }

                    WPFHelper.Invoke(() =>
                    {
                        vizHandle = view.host.TargetWindowHandle;
                    });

                } while (vizHandle == IntPtr.Zero);

                // Step 4. 启动完成
                WPFHelper.BeginInvoke(() =>
                {
                    this.Support.IsEngineReady = true;

                    // 发送引擎嵌入完成消息
                    VizRenderReadyMessage msg = new VizRenderReadyMessage();
                    ApplicationDomainEx.MessageManager.Send(msg);
                });
            });
        }
    }
}
