﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.TVP.Domain;
using VIZ.TVP.Storage;

namespace VIZ.TVP.Service
{
    /// <summary>
    /// 包装连接服务
    /// </summary>
    public class TVPConnectionService : ITVPConnectionService
    {
        /// <summary>
        /// 锁对象
        /// </summary>
        private static object lock_object = new object();

        /// <summary>
        /// 加载包装连接分组
        /// </summary>
        /// <returns>包装连接分组</returns>
        public ObservableCollection<TVPConnectionGroupModel> GetGroups()
        {
            List<TVPConnectionGroupModel> list = new List<TVPConnectionGroupModel>();

            foreach (TVPConnectionGroupEntity groupEntity in ApplicationDomainEx.DataBaseManager.LiteDbContext.TVPConnectionGroup.FindAll())
            {
                TVPConnectionGroupModel groupModel = new TVPConnectionGroupModel(groupEntity);
                groupModel.PropertyFromEntity();

                list.Add(groupModel);
            }

            Dictionary<Guid, TVPConnectionGroupModel> dic = list.ToDictionary(p => p.GroupID, p => p);

            foreach (TVPConnectionEntity entity in ApplicationDomainEx.DataBaseManager.LiteDbContext.TVPConnection.FindAll())
            {
                TVPConnectionModel model = new TVPConnectionModel(entity);
                model.PropertyFromEntity();

                if (!dic.TryGetValue(model.GroupID, out TVPConnectionGroupModel groupModel))
                    continue;

                groupModel.Items.Add(model);
            }

            foreach (var groupModel in list)
            {
                groupModel.Items = groupModel.Items.OrderBy(p => p.OrderIndex).ToObservableCollection();
            }

            return list.OrderBy(p => p.OrderIndex).ToObservableCollection();
        }

        /// <summary>
        /// 保存包装连接分组集合
        /// </summary>
        /// <param name="groupModels">分组集合</param>
        public void SaveGroups(IList<TVPConnectionGroupModel> groupModels)
        {
            List<TVPConnectionGroupEntity> groups = new List<TVPConnectionGroupEntity>();
            List<TVPConnectionEntity> items = new List<TVPConnectionEntity>();

            for (int i = 0; i < groupModels.Count; i++)
            {
                TVPConnectionGroupModel groupModel = groupModels[i];
                groupModel.OrderIndex = i;
                groupModel.PropertyToEntity();
                groups.Add(groupModel.Entity);

                for (int j = 0; j < groupModel.Items.Count; j++)
                {
                    TVPConnectionModel model = groupModel.Items[j];
                    model.OrderIndex = j;
                    model.PropertyToEntity();

                    items.Add(model.Entity);
                }
            }

            lock (lock_object)
            {
                ApplicationDomainEx.DataBaseManager.LiteDbContext.TVPConnectionGroup.DeleteAll();
                ApplicationDomainEx.DataBaseManager.LiteDbContext.TVPConnection.DeleteAll();
                ApplicationDomainEx.DataBaseManager.LiteDbContext.TVPConnectionGroup.Insert(groups);
                ApplicationDomainEx.DataBaseManager.LiteDbContext.TVPConnection.Insert(items);
            }
        }
    }
}
