﻿using System;
using System.Collections.Generic;
using System.Dynamic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.TVP.Domain;
using VIZ.TVP.Storage;

namespace VIZ.TVP.Service
{
    /// <summary>
    /// VIZ命令ControlObject服务
    /// </summary>
    public interface IVizCommandControlObjectService
    {
        /// <summary>
        /// 获取控制对象XML数据
        /// </summary>
        /// <param name="xml">xml内容</param> 
        /// <param name="schema">定义信息</param>
        /// <param name="columns">列信息</param>
        /// <param name="items">数据源</param>
        /// <returns></returns>
        void GetControlObjectXmlData(string xml, ControlObject_Schema_Node schema, out List<GridColumnDefinition> columns, out List<ExpandoObject> items);

        /// <summary>
        /// 获取控制对象XML数据
        /// </summary>
        /// <param name="items">控制对象数据</param>
        /// <returns>XML数据</returns>
        string GetControlObjectXml(List<ExpandoObject> items);

        /// <summary>
        /// 获取场景树节点信息
        /// </summary>
        /// <param name="connection">连接</param>
        /// <param name="layer">场景图层</param>
        /// <returns>场景树节点信息</returns>
        List<VizTreeNodeInfo> GetTreeNodeList(TVPConnectionModel connection, VizSceneLayerEnum layer);

        /// <summary>
        /// 获取控制对象列表
        /// </summary>
        /// <param name="connection">连接</param>
        /// <param name="programListItemModel">节目单项模型</param>
        /// <param name="layer">场景图层</param>
        /// <returns>控制对象列表</returns>
        List<VizControlObjectModel> GetControlObjectList(TVPConnectionModel connection, ProgramListItemModel programListItemModel, VizSceneLayerEnum layer);

        /// <summary>
        /// 设置控制对象值
        /// </summary>
        /// <param name="connection">连接</param>
        /// <param name="layer">场景图层</param>
        /// <param name="treeNodePath">场景节点路径</param>
        /// <param name="fieldIdentifier">字段</param>
        /// <param name="value">值</param>
        void SetControlObjectValue(TVPConnectionModel connection, VizSceneLayerEnum layer, string treeNodePath, string fieldIdentifier, string value);

        /// <summary>
        /// 设置控制对象值
        /// </summary>
        /// <param name="connection">连接</param>
        /// <param name="layer">场景图层</param>
        /// <param name="obj">控制对象</param>
        void SetControlObjectValue(TVPConnectionModel connection, VizSceneLayerEnum layer, VizControlObjectModel obj);

        /// <summary>
        /// 获取控制对象字段类型
        /// </summary>
        /// <param name="type">字段类型</param>
        /// <returns>控制对象字段类型</returns>
        VizControlObjectFieldType GetControlObjectFieldType(string type);
    }
}