﻿using CsvHelper;
using log4net;
using System;
using System.Collections.Generic;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Storage;

namespace VIZ.TVP.Storage
{
    /// <summary>
    /// CSV上下文
    /// </summary>
    public class CsvContext
    {
        /// <summary>
        /// 日志
        /// </summary>
        private readonly static ILog log = LogManager.GetLogger(typeof(CsvContext));

        /// <summary>
        /// 插件配置
        /// </summary>
        [Csv(Scene = CsvScene.Read)]
        public List<PluginConfig> PluginConfig { get; private set; }

        /// <summary>
        /// 加载插件配置
        /// </summary>
        /// <param name="path">文件路径</param>
        public void LoadPluginConfig(string path)
        {
            using (StreamReader sr = new StreamReader(path, Encoding.Default))
            using (CsvReader reader = new CsvReader(sr, CultureInfo.InvariantCulture))
            {
                this.PluginConfig = reader.GetRecords<PluginConfig>()?.ToList();
            }
        }
    }
}
