﻿using LiteDB;
using log4net;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.TVP.Storage
{
    /// <summary>
    /// 本地缓存数据库
    /// </summary>
    public class LiteDbContext : IDisposable
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog log = LogManager.GetLogger(typeof(LiteDbContext));

        /// <summary>
        /// 数据库
        /// </summary>
        private ILiteDatabase Database;

        /// <summary>
        /// LiteDB数据库
        /// </summary>
        /// <param name="path">数据库路径</param>
        public LiteDbContext(string path)
        {
            this.Path = path;

            this.Database = new LiteDatabase(path);

            // 本地信息
            this.LocalInfo = this.Database.GetCollection<LocalInfoEntity>();

            // 包装连接
            this.TVPConnectionGroup = this.Database.GetCollection<TVPConnectionGroupEntity>();
            this.TVPConnection = this.Database.GetCollection<TVPConnectionEntity>();
            this.TVPEngineConfig = this.Database.GetCollection<TVPEngineConfig>();
        }

        /// <summary>
        /// 数据库文件路径
        /// </summary>
        public string Path { get; private set; }

        // -----------------------------------------------------------------------------------------------------------
        // -- 表 -- 
        // -----------------------------------------------------------------------------------------------------------

        /// <summary>
        /// 本地信息
        /// </summary>
        public ILiteCollection<LocalInfoEntity> LocalInfo { get; private set; }

        /// <summary>
        /// 连接分组
        /// </summary>
        public ILiteCollection<TVPConnectionGroupEntity> TVPConnectionGroup { get; private set; }

        /// <summary>
        /// 连接
        /// </summary>
        public ILiteCollection<TVPConnectionEntity> TVPConnection { get; private set; }

        /// <summary>
        /// 引擎配置
        /// </summary>
        public ILiteCollection<TVPEngineConfig> TVPEngineConfig { get; private set; }

        /// <summary>
        /// 销毁
        /// </summary>
        public void Dispose()
        {
            this.TVPConnectionGroup = null;
            this.TVPConnection = null;
            this.TVPEngineConfig = null;

            this.Database?.Dispose();
        }
    }
}