﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using VIZ.Framework.Core;

namespace VIZ.TVP.Storage
{
    /// <summary>
    /// 控制对象元素节点
    /// </summary>
    public class ControlObject_Element_Node : IXmlSerialize
    {
        /// <summary>
        /// 描述
        /// </summary>
        public string Description { get; set; }

        /// <summary>
        /// 实体集合
        /// </summary>
        public List<ControlObject_Entry_Node> Entrys { get; set; } = new List<ControlObject_Entry_Node>();

        /// <summary>
        /// 从XElement节点获取数据
        /// </summary>
        /// <param name="element">XElement节点</param>
        public void FromXmlElement(XElement element)
        {
            this.Description = element.GetAttributeValue<string>("description");

            foreach (var item in element.Elements("entry"))
            {
                ControlObject_Entry_Node entry = new ControlObject_Entry_Node();
                entry.FromXmlElement(item);

                this.Entrys.Add(entry);
            }
        }

        /// <summary>
        /// 转化为XElement节点
        /// </summary>
        public XElement ToXmlElement()
        {
            XElement element = new XElement("element");
            element.SetAttributeValue("description", this.Description);
            foreach (var item in this.Entrys)
            {
                element.Add(item.ToXmlElement());
            }

            return element;
        }
    }
}
