﻿using DevExpress.Xpf.Core;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Core;
using VIZ.Framework.Module;
using VIZ.TVP.Domain;
using VIZ.TVP.Module;

namespace VIZ.TVP
{
    /// <summary>
    /// App.xaml 的交互逻辑
    /// </summary>
    public partial class App : Application
    {
        public App()
        {
            // 设置DevExpress主推
            ApplicationThemeHelper.ApplicationThemeName = Theme.VS2019DarkName;

            // 初始化LiteDB
            AppSetup.AppendSetup(new AppSetup_InitLiteDB());
            // 初始化CSV
            AppSetup.AppendSetup(new AppSetup_InitCSV());

            // 执行启动流程
            AppSetupContext context = AppSetup.Setup();

            if (context.Exception != null)
            {
                MessageBox.Show($"执行 {context.ProviderDetail} 失败\r\n{context.Exception.Message}");
            }

            if (!context.IsSuccess)
            {
                Environment.Exit(-1);
            }

            // 初始化窗口
            ApplicationDomainEx.WindowManager.LoginWindowType = typeof(LoginWindow);
            ApplicationDomainEx.WindowManager.MainWindowType = typeof(MainWindow);
            ApplicationDomainEx.WindowManager.LoginWindow = new LoginWindow();
            ApplicationDomainEx.WindowManager.LoginWindow.Show();

            // 调试窗口
            if (ApplicationDomainEx.IS_DEBUG)
            {
                DebugWindow debugWindow = new DebugWindow();
                debugWindow.Show();
                debugWindow.Topmost = true;
            }
        }
    }
}
