﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Domain;
using VIZ.Framework.Plugin;
using VIZ.TVP.Storage;

namespace VIZ.TVP.Domain
{
    /// <summary>
    /// 应用程序域
    /// </summary>
    public class ApplicationDomainEx : ApplicationDomain
    {
        /// <summary>
        /// 插件管理器
        /// </summary>
        public static PluginManager PluginManager { get; private set; } = new PluginManager();

        /// <summary>
        /// 窗口管理器
        /// </summary>
        public static WindowManager WindowManager { get; private set; } = new WindowManager();

        /// <summary>
        /// 数据库管理器
        /// </summary>
        public static DataBaseManager DataBaseManager { get; private set; } = new DataBaseManager();

        /// <summary>
        /// 包装连接管理器
        /// </summary>
        public static TVPConnectionManager TVPConnectionManager { get; private set; } = new TVPConnectionManager();

        /// <summary>
        /// 选择管理器
        /// </summary>
        public static SelectionManager SelectionManager { get; private set; } = new SelectionManager();

        /// <summary>
        /// 本地VIZ渲染器管理器
        /// </summary>
        public static LocalVizManager LocalVizManager { get; private set; } = new LocalVizManager();

        /// <summary>
        /// 当前项目领域
        /// </summary>
        public static ProjectDomain CurrentProjectDomain { get; set; }
    }
}