﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using DevExpress.Xpf.Editors.Settings;
using DevExpress.Xpf.Grid;

namespace VIZ.TVP.Domain
{
    /// <summary>
    /// DEV控件列定义对象
    /// </summary>
    public class GridColumnDefinition
    {
        /// <summary>
        /// DEV控件列定义对象
        /// </summary>
        public GridColumnDefinition()
        {
            Width = double.NaN;
        }

        /// <summary>
        /// 绑定字段
        /// </summary>
        public string FieldName { get; set; }

        /// <summary>
        /// 行数据模板
        /// </summary>
        public DataTemplate CellTemplate { get; set; }

        /// <summary>
        /// 宽度
        /// </summary>
        public GridColumnWidth Width { get; set; }

        /// <summary>
        /// 固定宽度
        /// </summary>
        public bool FixedWidth { get; set; }

        /// <summary>
        /// 编辑器设置
        /// </summary>
        public BaseEditSettings EditSettings { get; set; }

        /// <summary>
        /// 头部
        /// </summary>
        public object Header { get; set; }

        /// <summary>
        /// 是否只读
        /// </summary>
        public bool ReadOnly { get; set; }
    }
}
