﻿using System;
using System.Collections.Generic;
using System.Dynamic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.TVP.Storage;

namespace VIZ.TVP.Domain
{
    /// <summary>
    /// Viz控制对象字段模型
    /// </summary>
    public class VizControlObjectFieldModel : ModelBase
    {
        /// <summary>
        /// Viz控制对象字段模型
        /// </summary>
        /// <param name="entity">实体</param>
        public VizControlObjectFieldModel(VizControlObjectFieldEntity entity)
        {
            this.Entity = entity;
        }

        /// <summary>
        /// 实体
        /// </summary>
        public VizControlObjectFieldEntity Entity { get; private set; }

        #region TreeNodePath -- 所在场景节点路径

        private string treeNodePath;
        /// <summary>
        /// 所在场景节点路径
        /// </summary>
        public string TreeNodePath
        {
            get { return treeNodePath; }
            set { treeNodePath = value; this.RaisePropertyChanged(nameof(TreeNodePath)); }
        }

        #endregion

        #region PropertyPath -- 属性路径

        private string propertyPath;
        /// <summary>
        /// 属性路径
        /// </summary>
        public string PropertyPath
        {
            get { return propertyPath; }
            set { propertyPath = value; this.RaisePropertyChanged(nameof(PropertyPath)); }
        }

        #endregion

        #region FieldIdentifier -- 字段名称

        private string fieldIdentifier;
        /// <summary>
        /// 字段名称
        /// </summary>
        public string FieldIdentifier
        {
            get { return fieldIdentifier; }
            set { fieldIdentifier = value; this.RaisePropertyChanged(nameof(FieldIdentifier)); }
        }

        #endregion

        #region Value -- 值

        public string _value;
        /// <summary>
        /// 值
        /// </summary>
        public string Value
        {
            get { return _value; }
            set
            {
                _value = value;
                this.RaisePropertyChanged(nameof(Value));

                // 发送值改变消息
                VizControlObjectFieldValueChangedMessage msg = new VizControlObjectFieldValueChangedMessage();
                msg.FieldModel = this;

                ApplicationDomainEx.MessageManager.Send(msg);
            }
        }

        #endregion

        #region Description -- 描述

        private string description;
        /// <summary>
        /// 描述
        /// </summary>
        public string Description
        {
            get { return description; }
            set { description = value; this.RaisePropertyChanged(nameof(Description)); }
        }

        #endregion

        #region Type -- 字段类型

        private VizControlObjectFieldType type;
        /// <summary>
        /// 字段类型
        /// </summary>
        public VizControlObjectFieldType Type
        {
            get { return type; }
            set { type = value; this.RaisePropertyChanged(nameof(Type)); }
        }

        #endregion

        #region FieldSchema -- 字段定义

        private ControlObject_Field_node fieldSchema;
        /// <summary>
        /// 字段定义
        /// </summary>
        public ControlObject_Field_node FieldSchema
        {
            get { return fieldSchema; }
            set { fieldSchema = value; this.RaisePropertyChanged(nameof(FieldSchema)); }
        }

        #endregion

        // ===========================================================
        // 扩展属性
        // ===========================================================

        #region ProgramListItemModel -- 所在节目单项模型

        private ProgramListItemModel programListItemModel;
        /// <summary>
        /// 所在节目单项模型
        /// </summary>
        public ProgramListItemModel ProgramListItemModel
        {
            get { return programListItemModel; }
            set { programListItemModel = value; this.RaisePropertyChanged(nameof(ProgramListItemModel)); }
        }

        #endregion

        #region VizControlObjectModel -- 所属控制对象

        private VizControlObjectModel vizControlObjectModel;
        /// <summary>
        /// 所属控制对象
        /// </summary>
        public VizControlObjectModel VizControlObjectModel
        {
            get { return vizControlObjectModel; }
            set { vizControlObjectModel = value; this.RaisePropertyChanged(nameof(VizControlObjectModel)); }
        }

        #endregion

        #region IsXmlValueLoaded -- Xml类型数据是否已经加载

        private bool isXmlValueLoaded;
        /// <summary>
        /// Xml类型数据是否已经加载
        /// </summary>
        public bool IsXmlValueLoaded
        {
            get { return isXmlValueLoaded; }
            set { isXmlValueLoaded = value; this.RaisePropertyChanged(nameof(IsXmlValueLoaded)); }
        }

        #endregion

        #region ListValue -- list类型数据列表

        private List<ExpandoObject> listValue;
        /// <summary>
        /// list类型数据列表
        /// </summary>
        public List<ExpandoObject> ListValue
        {
            get { return listValue; }
            set { listValue = value; this.RaisePropertyChanged(nameof(ListValue)); }
        }

        #endregion

        #region ListValueColumns -- List类型数据列信息

        private List<GridColumnDefinition> listValueColumns;
        /// <summary>
        /// List类型数据列信息
        /// </summary>
        public List<GridColumnDefinition> ListValueColumns
        {
            get { return listValueColumns; }
            set { listValueColumns = value; this.RaisePropertyChanged(nameof(ListValueColumns)); }
        }

        #endregion
    }
}
