﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.TVP.Storage;

namespace VIZ.TVP.Domain
{
    /// <summary>
    /// Viz控制对象模型
    /// </summary>
    public class VizControlObjectModel : ModelBase
    {
        /// <summary>
        /// Viz控制对象模型
        /// </summary>
        /// <param name="entity">实体</param>
        public VizControlObjectModel(VizControlObjectEntity entity)
        {
            this.Entity = entity;
        }

        /// <summary>
        /// 实体
        /// </summary>
        public VizControlObjectEntity Entity { get; private set; }

        #region TreeNodeName -- 所在场景节点名称

        private string treeNodeName;
        /// <summary>
        /// 所在场景节点名称
        /// </summary>
        public string TreeNodeName
        {
            get { return treeNodeName; }
            set { treeNodeName = value; this.RaisePropertyChanged(nameof(TreeNodeName)); }
        }

        #endregion

        #region TreeNodePath -- 所在场景节点路径

        private string treeNodePath;
        /// <summary>
        /// 所在场景节点路径
        /// </summary>
        public string TreeNodePath
        {
            get { return treeNodePath; }
            set { treeNodePath = value; this.RaisePropertyChanged(nameof(TreeNodePath)); }
        }

        #endregion

        #region Description -- 描述

        private string description;
        /// <summary>
        /// 描述
        /// </summary>
        public string Description
        {
            get { return description; }
            set { description = value; this.RaisePropertyChanged(nameof(Description)); }
        }

        #endregion

        // ======================================================================
        // 扩展属性
        // ======================================================================

        #region ProgramListItemModel -- 所在节目单项模型

        private ProgramListItemModel programListItemModel;
        /// <summary>
        /// 所在节目单项模型
        /// </summary>
        public ProgramListItemModel ProgramListItemModel
        {
            get { return programListItemModel; }
            set { programListItemModel = value; this.RaisePropertyChanged(nameof(ProgramListItemModel)); }
        }

        #endregion

        #region VizTreeNodeInfo -- 场景树节点信息

        private VizTreeNodeInfo treeNodeInfo;
        /// <summary>
        /// 场景树节点信息
        /// </summary>
        public VizTreeNodeInfo TreeNodeInfo
        {
            get { return treeNodeInfo; }
            set { treeNodeInfo = value; this.RaisePropertyChanged(nameof(TreeNodeInfo)); }
        }

        #endregion

        #region Fields -- 字段结合

        private ObservableCollection<VizControlObjectFieldModel> fields = new ObservableCollection<VizControlObjectFieldModel>();
        /// <summary>
        /// 字段结合
        /// </summary>
        public ObservableCollection<VizControlObjectFieldModel> Fields
        {
            get { return fields; }
            set { fields = value; this.RaisePropertyChanged(nameof(Fields)); }
        }

        #endregion
    }
}
