﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.TVP.Storage;

namespace VIZ.TVP.Domain
{
    /// <summary>
    /// 插件配置模型
    /// </summary>
    public class PluginConfigModel : ModelBase
    {
        #region ID -- 编号

        private string id;
        /// <summary>
        /// 编号
        /// </summary>
        public string ID
        {
            get { return id; }
            set { id = value; this.RaisePropertyChanged(nameof(ID)); }
        }

        #endregion

        #region PluginID -- 插件ID

        private string pluginID;
        /// <summary>
        /// 插件ID
        /// </summary>
        public string PluginID
        {
            get { return pluginID; }
            set { pluginID = value; this.RaisePropertyChanged(nameof(PluginID)); }
        }

        #endregion

        #region Group -- 分组

        private string group;
        /// <summary>
        /// 分组
        /// </summary>
        public string Group
        {
            get { return group; }
            set { group = value; this.RaisePropertyChanged(nameof(Group)); }
        }

        #endregion

        #region DisplayName -- 显示名称

        private string displayName;
        /// <summary>
        /// 显示名称
        /// </summary>
        public string DisplayName
        {
            get { return displayName; }
            set { displayName = value; this.RaisePropertyChanged(nameof(DisplayName)); }
        }

        #endregion

        #region Type -- 插件类型

        private PluginTypeEnum type;
        /// <summary>
        /// 类型 Plguin | TemplatePlugin
        /// </summary>
        public PluginTypeEnum Type
        {
            get { return type; }
            set { type = value; this.RaisePropertyChanged(nameof(Type)); }
        }

        #endregion

        /// <summary>
        /// 从配置文件中获取属性
        /// </summary>
        /// <param name="config">配置文件项</param>
        public void PropertyFromConfig(PluginConfig config)
        {
            this.ID = config.ID;
            this.PluginID = config.PluginID;
            this.Group = config.Group;
            this.DisplayName = config.DisplayName;
            this.Type = config.Type;
        }
    }
}
