﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace VIZ.TVP.Module
{
    /// <summary>
    /// TextInputView.xaml 的交互逻辑
    /// </summary>
    public partial class TextInputView : UserControl
    {
        public TextInputView()
        {
            InitializeComponent();
        }

        #region Label -- 标签

        /// <summary>
        /// 标签
        /// </summary>
        public string Label
        {
            get { return (string)GetValue(LabelProperty); }
            set { SetValue(LabelProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for Label.  This enables animation, styling, binding, etc... 
        /// </summary>
        public static readonly DependencyProperty LabelProperty =
            DependencyProperty.Register("Label", typeof(string), typeof(TextInputView), new PropertyMetadata(null));

        #endregion

        #region Text -- 输入文本

        /// <summary>
        /// 输入文本
        /// </summary>
        public string Text
        {
            get { return (string)GetValue(TextProperty); }
            set { SetValue(TextProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for Text.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty TextProperty =
            DependencyProperty.Register("Text", typeof(string), typeof(TextInputView), new PropertyMetadata(null));

        #endregion

        /// <summary>
        /// 是否确定
        /// </summary>
        public bool IsEnter { get; set; }

        /// <summary>
        /// 确定
        /// </summary>
        private void btEnter_Click(object sender, RoutedEventArgs e)
        {
            this.IsEnter = true;

            Window window = Window.GetWindow(this);
            window.DialogResult = true;

            window.Close();
        }

        /// <summary>
        /// 取消
        /// </summary>
        private void btCancel_Click(object sender, RoutedEventArgs e)
        {
            this.IsEnter = false;

            Window window = Window.GetWindow(this);
            window.DialogResult = false;

            window.Close();
        }
    }
}
