﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.TVP.Domain;
using VIZ.TVP.Storage;

namespace VIZ.TVP.Service
{
    /// <summary>
    /// 节目服务
    /// </summary>
    public interface IProgramService
    {
        /// <summary>
        /// 加载节目模板集合
        /// </summary>
        /// <returns>节目模板集合</returns>
        ObservableCollection<ProgramTemplateModel> LoadProgramTemplateModels();

        /// <summary>
        /// 保存节目模板集合
        /// </summary>
        /// <param name="models">节目模板集合</param>
        void SaveProgramTemplateModels(IList<ProgramTemplateModel> models);

        /// <summary>
        /// 加载节目单集合
        /// </summary>
        /// <returns>节目单集合</returns>
        ObservableCollection<ProgramListModel> LoadProgramListModels();

        /// <summary>
        /// 保存节目单模型集合
        /// </summary>
        /// <param name="models">节目单模型集合</param>
        void SaveProgramListModels(IList<ProgramListModel> models);
    }
}
