﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.TVP.Storage
{
    /// <summary>
    /// 节目单项
    /// </summary>
    public class ProgramListItemEntity
    {
        /// <summary>
        /// 模板ID
        /// </summary>
        public string TemplateID { get; set; }

        /// <summary>
        /// 所属节目单ID
        /// </summary>
        public string ListID { get; set; }

        /// <summary>
        /// 模板类型
        /// </summary>
        public ProgramTemplateType TemplateType { get; set; }

        /// <summary>
        /// 场景名
        /// </summary>
        public string SceneName { get; set; }

        /// <summary>
        /// 路径
        /// </summary>
        public string Path { get; set; }

        /// <summary>
        /// 缩略图
        /// </summary>
        public string Thumbnail { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string Remark { get; set; }

        /// <summary>
        /// 层
        /// </summary>
        public string Layer { get; set; }

        /// <summary>
        /// 引擎类型
        /// </summary>
        public TVPEngineType EngineType { get; set; }

        /// <summary>
        /// 插件ID
        /// </summary>
        public string PluginID { get; set; }

        /// <summary>
        /// 控制对象字段集合
        /// </summary>
        public List<VizControlObjectFieldEntity> ControlObjectFields { get; set; }
    }
}
