﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;

namespace VIZ.TVP.Storage
{
    /// <summary>
    /// 控制对象定义节点
    /// </summary>
    public class ControlObject_Schema_Node : IXmlSerialize
    {
        /// <summary>
        /// 字段集合
        /// </summary>
        public List<ControlObject_Field_node> Fields { get; set; } = new List<ControlObject_Field_node>();

        /// <summary>
        /// 从XElement节点获取数据
        /// </summary>
        /// <param name="element">XElement节点</param>
        public void FromXmlElement(XElement element)
        {
            foreach (var item in element.Elements("field"))
            {
                ControlObject_Field_node field = new ControlObject_Field_node();
                field.FromXmlElement(item);

                this.Fields.Add(field);
            }
        }

        /// <summary>
        /// 转化为XElement节点
        /// </summary>
        public XElement ToXmlElement()
        {
            throw new NotImplementedException();
        }
    }
}
