﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using VIZ.Framework.Core;

namespace VIZ.TVP.Storage
{
    /// <summary>
    /// GH Link 节点
    /// </summary>
    public class GH_Link_Node : IXmlSerialize
    {
        /// <summary>
        /// 引用
        /// <see cref="GH_Link_Rel_Enums"/>
        /// </summary>
        public string rel { get; set; }

        /// <summary>
        /// 类型
        /// <see cref="GH_Link_Type_Enums"/>
        /// </summary>
        public string type { get; set; }

        /// <summary>
        /// 引用
        /// </summary>
        public string href { get; set; }

        /// <summary>
        /// 从XElement节点获取数据
        /// </summary>
        /// <param name="element">XElement节点</param>
        public void FromXmlElement(XElement element)
        {
            if (element == null)
                return;

            this.href = element.GetAttributeValue<string>("href");
            this.rel = element.GetAttributeValue<string>("rel");
            this.type = element.GetAttributeValue<string>("type");

        }

        /// <summary>
        /// 转化为XElement节点
        /// </summary>
        public XElement ToXmlElement()
        {
            throw new NotSupportedException();
        }
    }
}
