﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.TVP.Storage;

namespace VIZ.TVP.Domain
{
    /// <summary>
    /// Viz控制对象字段模型
    /// </summary>
    public class VizControlObjectFieldModel : ModelBase
    {
        /// <summary>
        /// Viz控制对象字段模型
        /// </summary>
        /// <param name="entity">实体</param>
        public VizControlObjectFieldModel(VizControlObjectFieldEntity entity)
        {
            this.Entity = entity;
        }

        /// <summary>
        /// 实体
        /// </summary>
        public VizControlObjectFieldEntity Entity { get; private set; }

        #region TreeNodePath -- 所在场景节点路径

        private string treeNodePath;
        /// <summary>
        /// 所在场景节点路径
        /// </summary>
        public string TreeNodePath
        {
            get { return treeNodePath; }
            set { treeNodePath = value; this.RaisePropertyChanged(nameof(TreeNodePath)); }
        }

        #endregion

        #region PropertyPath -- 属性路径

        private string propertyPath;
        /// <summary>
        /// 属性路径
        /// </summary>
        public string PropertyPath
        {
            get { return propertyPath; }
            set { propertyPath = value; this.RaisePropertyChanged(nameof(PropertyPath)); }
        }

        #endregion

        #region FieldIdentifier -- 字段名称

        private string fieldIdentifier;
        /// <summary>
        /// 字段名称
        /// </summary>
        public string FieldIdentifier
        {
            get { return fieldIdentifier; }
            set { fieldIdentifier = value; this.RaisePropertyChanged(nameof(FieldIdentifier)); }
        }

        #endregion

        #region Value -- 值

        private string _value;
        /// <summary>
        /// 值
        /// </summary>
        public string Value
        {
            get { return _value; }
            set { _value = value; this.RaisePropertyChanged(nameof(Value)); }
        }

        #endregion

        #region Description -- 描述

        private string description;
        /// <summary>
        /// 描述
        /// </summary>
        public string Description
        {
            get { return description; }
            set { description = value; this.RaisePropertyChanged(nameof(Description)); }
        }

        #endregion

        #region Type -- 字段类型

        private VizControlObjectFieldType type;
        /// <summary>
        /// 字段类型
        /// </summary>
        public VizControlObjectFieldType Type
        {
            get { return type; }
            set { type = value; this.RaisePropertyChanged(nameof(Type)); }
        }

        #endregion
    }
}
