﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.TVP.Storage;

namespace VIZ.TVP.Domain
{
    /// <summary>
    /// 节目单项模型
    /// </summary>
    public class ProgramListItemModel : ModelBase
    {
        /// <summary>
        /// 节目单项模型
        /// </summary>
        /// <param name="entity">节目单项实体</param>
        public ProgramListItemModel(ProgramListItemEntity entity)
        {
            this.Entity = entity;
        }

        /// <summary>
        /// 实体
        /// </summary>
        public ProgramListItemEntity Entity { get; private set; }

        /// <summary>
        /// 对象ID
        /// </summary>
        public string ObjectID { get; private set; } = Guid.NewGuid().ToString();

        #region TemplateID -- 模板ID

        private string templateID;
        /// <summary>
        /// 模板ID
        /// </summary>
        public string TemplateID
        {
            get { return templateID; }
            set { templateID = value; this.RaisePropertyChanged(nameof(TemplateID)); }
        }

        #endregion

        #region ListID -- 所属节目单ID

        private string listID;
        /// <summary>
        /// 所属节目单ID
        /// </summary>
        public string ListID
        {
            get { return listID; }
            set { listID = value; this.RaisePropertyChanged(nameof(ListID)); }
        }

        #endregion

        #region ProgramListModel -- 节目单模型

        private ProgramListModel programListModel;
        /// <summary>
        /// 节目单模型
        /// </summary>
        public ProgramListModel ProgramListModel
        {
            get { return programListModel; }
            set { programListModel = value; this.RaisePropertyChanged(nameof(ProgramListModel)); }
        }

        #endregion

        #region TemplateType -- 模板类型

        private ProgramTemplateType templateType;
        /// <summary>
        /// 模板类型
        /// </summary>
        public ProgramTemplateType TemplateType
        {
            get { return templateType; }
            set { templateType = value; this.RaisePropertyChanged(nameof(TemplateType)); }
        }

        #endregion

        #region SceneName -- 场景名

        private string sceneName;
        /// <summary>
        /// 场景名
        /// </summary>
        public string SceneName
        {
            get { return sceneName; }
            set { sceneName = value; this.RaisePropertyChanged(nameof(SceneName)); }
        }

        #endregion

        #region Path -- 路径

        private string path;
        /// <summary>
        /// 路径
        /// </summary>
        public string Path
        {
            get { return path; }
            set { path = value; this.RaisePropertyChanged(nameof(Path)); }
        }

        #endregion

        #region Remark -- 备注

        private string remark;
        /// <summary>
        /// 备注
        /// </summary>
        public string Remark
        {
            get { return remark; }
            set { remark = value; this.RaisePropertyChanged(nameof(Remark)); }
        }

        #endregion

        #region Layer -- 层

        private string layer;
        /// <summary>
        /// 层
        /// </summary>
        public string Layer
        {
            get { return layer; }
            set { layer = value; this.RaisePropertyChanged(nameof(Layer)); }
        }

        #endregion

        #region EngineType -- 引擎类型

        private TVPEngineType engineType;
        /// <summary>
        /// 引擎类型
        /// </summary>
        public TVPEngineType EngineType
        {
            get { return engineType; }
            set { engineType = value; this.RaisePropertyChanged(nameof(EngineType)); }
        }

        #endregion

        #region PluginID -- 插件ID

        private string pluginID;
        /// <summary>
        /// 插件ID
        /// </summary>
        public string PluginID
        {
            get { return pluginID; }
            set { pluginID = value; this.RaisePropertyChanged(nameof(PluginID)); }
        }

        #endregion

        #region PluginName -- 插件名

        private string pluginName;
        /// <summary>
        /// 插件名
        /// </summary>
        public string PluginName
        {
            get { return pluginName; }
            set { pluginName = value; this.RaisePropertyChanged(nameof(PluginName)); }
        }

        #endregion

        #region Thumbnail -- 缩略图

        private string thumbnail;
        /// <summary>
        /// 缩略图
        /// </summary>
        public string Thumbnail
        {
            get { return thumbnail; }
            set { thumbnail = value; this.RaisePropertyChanged(nameof(Thumbnail)); }
        }

        #endregion

        #region OrderIndex -- 排序索引

        private int orderIndex;
        /// <summary>
        /// 排序索引
        /// </summary>
        public int OrderIndex
        {
            get { return orderIndex; }
            set { orderIndex = value; this.RaisePropertyChanged(nameof(OrderIndex)); }
        }

        #endregion

        // ---------------------------------------------------------------------
        // 扩展属性

        #region ThumbnailBitmap -- 缩略图图片

        private Bitmap thumbnailBitmap;
        /// <summary>
        /// 缩略图图片
        /// </summary>
        public Bitmap ThumbnailBitmap
        {
            get { return thumbnailBitmap; }
            set { thumbnailBitmap = value; this.RaisePropertyChanged(nameof(ThumbnailBitmap)); }
        }

        #endregion

        /// <summary>
        /// 从模板中获取数据
        /// </summary>
        /// <param name="template">模板</param>
        public void FromProgramTemplateModel(ProgramTemplateModel template)
        {
            this.TemplateID = template.TemplateID;
            this.TemplateType = template.TemplateType;
            this.SceneName = template.SceneName;
            this.Path = template.Path;
            this.Remark = template.Remark;
            this.Layer = template.Layer;
            this.EngineType = template.EngineType;
            this.Thumbnail = template.Thumbnail;
            this.ThumbnailBitmap = template.ThumbnailBitmap;
        }

        /// <summary>
        /// 从实体中获取属性
        /// </summary>
        public void PropertyFromEntity()
        {
            this.TemplateID = this.Entity.TemplateID;
            this.ListID = this.Entity.ListID;
            this.TemplateType = this.Entity.TemplateType;
            this.SceneName = this.Entity.SceneName;
            this.Path = this.Entity.Path;
            this.Remark = this.Entity.Remark;
            this.Thumbnail = this.Entity.Thumbnail;
            this.Layer = this.Entity.Layer;
            this.EngineType = this.Entity.EngineType;
            this.PluginID = this.Entity.PluginID;
            this.OrderIndex = this.Entity.OrderIndex;
        }

        /// <summary>
        /// 将属性填充至实体
        /// </summary>
        public void PropertyToEntity()
        {
            this.Entity.TemplateID = this.TemplateID;
            this.Entity.ListID = this.ListID;
            this.Entity.TemplateType = this.TemplateType;
            this.Entity.SceneName = this.SceneName;
            this.Entity.Path = this.Path;
            this.Entity.Remark = this.Remark;
            this.Entity.Thumbnail = this.Thumbnail;
            this.Entity.Layer = this.Layer;
            this.Entity.EngineType = this.EngineType;
            this.Entity.PluginID = this.PluginID;
            this.Entity.OrderIndex = this.OrderIndex;
        }
    }
}
