﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.TVP.Storage;

namespace VIZ.TVP.Domain
{
    /// <summary>
    /// 节目单模型
    /// </summary>
    public class ProgramListModel : ModelBase
    {
        /// <summary>
        /// 节目单模型
        /// </summary>
        /// <param name="entity">节目单实体</param>
        public ProgramListModel(ProgramListEntity entity)
        {
            this.Entity = entity;
        }

        /// <summary>
        /// 实体
        /// </summary>
        public ProgramListEntity Entity { get; private set; }

        #region ListID -- 节目单ID

        private string listID;
        /// <summary>
        /// 节目单ID
        /// </summary>
        public string ListID
        {
            get { return listID; }
            set { listID = value; this.RaisePropertyChanged(nameof(ListID)); }
        }

        #endregion

        #region Name -- 名称

        private string name;
        /// <summary>
        /// 名称
        /// </summary>
        public string Name
        {
            get { return name; }
            set { name = value; this.RaisePropertyChanged(nameof(Name)); }
        }

        #endregion

        #region OrderIndex -- 排序索引

        private int orderIndex;
        /// <summary>
        /// 排序索引
        /// </summary>
        public int OrderIndex
        {
            get { return orderIndex; }
            set { orderIndex = value; this.RaisePropertyChanged(nameof(OrderIndex)); }
        }

        #endregion

        #region Items -- 子项集合

        private ObservableCollection<ProgramListItemModel> items = new ObservableCollection<ProgramListItemModel>();
        /// <summary>
        /// 子项集合
        /// </summary>
        public ObservableCollection<ProgramListItemModel> Items
        {
            get { return items; }
            set { items = value; this.RaisePropertyChanged(nameof(Items)); }
        }

        #endregion

        #region SelectedItem -- 当前选中的子项

        private ProgramListItemModel selectedItem;
        /// <summary>
        /// 当前选中的子项
        /// </summary>
        public ProgramListItemModel SelectedItem
        {
            get { return selectedItem; }
            set
            {
                selectedItem = value;
                this.RaisePropertyChanged(nameof(SelectedItem));

                ApplicationDomainEx.SelectionManager.ProgramListItemModel = value;

                ProgramListItemChangedMessage msg = new ProgramListItemChangedMessage();
                msg.ProgramListItemModel = value;

                ApplicationDomainEx.MessageManager.Send(msg);
            }
        }

        #endregion

        /// <summary>
        /// 从实体中获取属性
        /// </summary>
        public void PropertyFromEntity()
        {
            this.ListID = this.Entity.ListID;
            this.Name = this.Entity.Name;
            this.OrderIndex = this.Entity.OrderIndex;
        }

        /// <summary>
        /// 将属性填充至实体
        /// </summary>
        public void PropertyToEntity()
        {
            this.Entity.ListID = this.ListID;
            this.Entity.Name = this.Name;
            this.Entity.OrderIndex = this.OrderIndex;
        }
    }
}
