﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.TVP.Storage;

namespace VIZ.TVP.Domain
{
    /// <summary>
    /// 包装连接分组模型
    /// </summary>
    public class TVPConnectionGroupModel : ModelBase
    {
        /// <summary>
        /// 包装连接分组模型
        /// </summary>
        /// <param name="entity">实体</param>
        public TVPConnectionGroupModel(TVPConnectionGroupEntity entity)
        {
            this.Entity = entity;
        }

        /// <summary>
        /// 实体
        /// </summary>
        public TVPConnectionGroupEntity Entity { get; private set; }

        #region GroupID -- 分组ID

        private Guid groupID;
        /// <summary>
        /// 分组ID
        /// </summary>
        public Guid GroupID
        {
            get { return groupID; }
            set { groupID = value; this.RaisePropertyChanged(nameof(GroupID)); }
        }

        #endregion

        #region Name -- 名称

        private string name;
        /// <summary>
        /// 名称
        /// </summary>
        public string Name
        {
            get { return name; }
            set { name = value; this.RaisePropertyChanged(nameof(Name)); }
        }

        #endregion

        #region Items -- 子项集合

        private ObservableCollection<TVPConnectionModel> items = new ObservableCollection<TVPConnectionModel>();
        /// <summary>
        /// 子项集合
        /// </summary>
        public ObservableCollection<TVPConnectionModel> Items
        {
            get { return items; }
            set { items = value; this.RaisePropertyChanged(nameof(Items)); }
        }

        #endregion

        #region EngineType -- 引擎类型

        private TVPEngineType engineType;
        /// <summary>
        /// 引擎类型
        /// </summary>
        public TVPEngineType EngineType
        {
            get { return engineType; }
            set { engineType = value; this.RaisePropertyChanged(nameof(EngineType)); }
        }

        #endregion

        #region OrderIndex -- 排序

        private int orderIndex;
        /// <summary>
        /// 排序
        /// </summary>
        public int OrderIndex
        {
            get { return orderIndex; }
            set { orderIndex = value; this.RaisePropertyChanged(nameof(OrderIndex)); }
        }

        #endregion

        #region IsEnabled -- 是否启用

        private bool isEnabled;
        /// <summary>
        /// 是否启用
        /// </summary>
        public bool IsEnabled
        {
            get { return isEnabled; }
            set { isEnabled = value; this.RaisePropertyChanged(nameof(IsEnabled)); }
        }

        #endregion

        /// <summary>
        /// 从实体中获取属性
        /// </summary>
        public void PropertyFromEntity()
        {
            this.GroupID = this.Entity.GroupID;
            this.Name = this.Entity.Name;
            this.EngineType = this.Entity.EngineType;
            this.OrderIndex = this.Entity.OrderIndex;
            this.IsEnabled = this.Entity.IsEnabled;
        }

        /// <summary>
        /// 将属性填入实体
        /// </summary>
        public void PropertyToEntity()
        {
            this.Entity.GroupID = this.GroupID;
            this.Entity.Name = this.Name;
            this.Entity.EngineType = this.EngineType;
            this.Entity.OrderIndex = this.OrderIndex;
            this.Entity.IsEnabled = this.IsEnabled;
        }
    }
}
