﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.TVP.Storage;

namespace VIZ.TVP.Domain
{
    /// <summary>
    /// 包装连接模型
    /// </summary>
    public class TVPConnectionModel : ModelBase, IDisposable
    {
        /// <summary>
        /// 包装连接模型
        /// </summary>
        /// <param name="entity">实体</param>
        public TVPConnectionModel(TVPConnectionEntity entity)
        {
            this.Entity = entity;
        }

        /// <summary>
        /// 实体
        /// </summary>
        public TVPConnectionEntity Entity { get; private set; }

        #region GroupID -- 分组ID

        private Guid groupID;
        /// <summary>
        /// 分组ID
        /// </summary>
        public Guid GroupID
        {
            get { return groupID; }
            set { groupID = value; this.RaisePropertyChanged(nameof(GroupID)); }
        }

        #endregion

        #region IP -- IP地址

        private string ip;
        /// <summary>
        /// IP地址
        /// </summary>
        public string IP
        {
            get { return ip; }
            set { ip = value; this.RaisePropertyChanged(nameof(IP)); }
        }

        #endregion

        #region Port -- 端口

        private int port;
        /// <summary>
        /// 端口
        /// </summary>
        public int Port
        {
            get { return port; }
            set { port = value; this.RaisePropertyChanged(nameof(Port)); }
        }


        #endregion

        #region Remark -- 备注

        private string remark;
        /// <summary>
        /// 备注
        /// </summary>
        public string Remark
        {
            get { return remark; }
            set { remark = value; this.RaisePropertyChanged(nameof(Remark)); }
        }

        #endregion

        #region IsEnabled -- 是否启用

        private bool isEnabled;
        /// <summary>
        /// 是否启用
        /// </summary>
        public bool IsEnabled
        {
            get { return isEnabled; }
            set { isEnabled = value; this.RaisePropertyChanged(nameof(IsEnabled)); }
        }

        #endregion

        #region IsConnected -- 是否处于连接状态

        private bool isConnected;
        /// <summary>
        /// 是否处于连接状态
        /// </summary>
        public bool IsConnected
        {
            get { return isConnected; }
            set { isConnected = value; this.RaisePropertyChanged(nameof(IsConnected)); }
        }

        #endregion

        #region OrderIndex -- 排序

        private int orderIndex;
        /// <summary>
        /// 排序
        /// </summary>
        public int OrderIndex
        {
            get { return orderIndex; }
            set { orderIndex = value; this.RaisePropertyChanged(nameof(OrderIndex)); }
        }

        #endregion

        /// <summary>
        /// 连接终结点
        /// </summary>
        public ITVPEndpointManager EndpointManager { get; private set; }

        /// <summary>
        /// 从实体中获取属性
        /// </summary>
        public void PropertyFromEntity()
        {
            this.GroupID = this.Entity.GroupID;
            this.IP = this.Entity.IP;
            this.Port = this.Entity.Port;
            this.Remark = this.Entity.Remark;
            this.IsEnabled = this.Entity.IsEnabled;
            this.OrderIndex = this.Entity.OrderIndex;
        }

        /// <summary>
        /// 将属性填入实体
        /// </summary>
        public void PropertyToEntity()
        {
            this.Entity.GroupID = this.GroupID;
            this.Entity.IP = this.IP;
            this.Entity.Port = this.Port;
            this.Entity.Remark = this.Remark;
            this.Entity.IsEnabled = this.IsEnabled;
            this.Entity.OrderIndex = this.OrderIndex;
        }

        /// <summary>
        /// 初始化终结点管理器
        /// </summary>
        /// <param name="endpointManager">终结点管理器</param>
        public void InitEndpointManager(ITVPEndpointManager endpointManager)
        {
            if (this.EndpointManager != null)
            {
                this.EndpointManager.ConnectionStateChanged -= EndpointManager_ConnectionStateChanged;
            }

            this.EndpointManager = endpointManager;
            this.EndpointManager.ConnectionStateChanged -= EndpointManager_ConnectionStateChanged;
            this.EndpointManager.ConnectionStateChanged += EndpointManager_ConnectionStateChanged;
        }

        /// <summary>
        /// 销毁
        /// </summary>
        public void Dispose()
        {
            this.EndpointManager?.Dispose();
            this.EndpointManager = null;
        }

        /// <summary>
        /// 终结点连接状态改变时触发
        /// </summary>
        private void EndpointManager_ConnectionStateChanged(object sender, Framework.Connection.ConnectionStateChangedEventArgs e)
        {
            WPFHelper.BeginInvoke(() =>
            {
                this.IsConnected = e.IsConnected;
            });
        }

    }
}
