﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Framework.Plugin;
using VIZ.TVP.Domain;
using VIZ.TVP.Service;

namespace VIZ.TVP.Module
{
    /// <summary>
    /// Control List视图模型
    /// </summary>
    public class ControlListViewModel : PluginViewModelBase
    {
        public ControlListViewModel()
        {
            // 初始化命令
            this.initCommand();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void initCommand()
        {
            this.LoadedCommand = new VCommand(this.Loaded);
        }

        // ==================================================================================
        // Service & Control
        // ==================================================================================

        /// <summary>
        /// ControlObject命令服务
        /// </summary>
        private IVizCommandControlObjectService vizCommandControlObjectService = new VizCommandControlObjectService();

        // ==================================================================================
        // Command
        // ==================================================================================

        #region LoadedCommand -- 加载命令

        /// <summary>
        /// 加载命令
        /// </summary>
        public VCommand LoadedCommand { get; set; }

        /// <summary>
        /// 加载
        /// </summary>
        private void Loaded()
        {
            var result = this.vizCommandControlObjectService.GetControlObjectList(ApplicationDomainEx.TVPConnectionManager.LocalConnection, Storage.VizSceneLayerEnum.MAIN_SCENE);
        }

        #endregion

        // ==================================================================================
        // Public Function
        // ==================================================================================

        /// <summary>
        /// 销毁
        /// </summary>
        public override void Dispose()
        {

        }

    }
}
