﻿using log4net;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Framework.Plugin;
using VIZ.TVP.Domain;

namespace VIZ.TVP.Module
{
    /// <summary>
    /// 日志视图模型
    /// </summary>
    public class LogViewModel : PluginViewModelBase, ILogService
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static readonly ILog log = LogManager.GetLogger(typeof(LogViewModel));

        /// <summary>
        /// 日志视图模型
        /// </summary>
        public LogViewModel()
        {
            ApplicationDomainEx.ServiceManager.AddService(ServiceKeys.LOG_SERVICE, this);
        }

        // ==================================================================================
        // Public Function
        // ==================================================================================

        /// <summary>
        /// 添加日志
        /// </summary>
        /// <param name="log"></param>
        public void AppendLog(string log)
        {
            WPFHelper.BeginInvoke(() =>
            {
                LogView view = this.GetView<LogView>();
                if (view == null)
                    return;

                view.tb.AppendText($"{log}\r\n");
            });
        }

        /// <summary>
        /// 清理日志
        /// </summary>
        public void ClearLog()
        {
            WPFHelper.BeginInvoke(() =>
            {
                LogView view = this.GetView<LogView>();
                if (view == null)
                    return;

                view.tb.Clear();
            });
        }

        /// <summary>
        /// 销毁
        /// </summary>
        public override void Dispose()
        {

        }
    }
}
