﻿using DevExpress.Mvvm;
using DevExpress.Mvvm.Xpf;
using DevExpress.Xpf.Core;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.TVP.Domain;

namespace VIZ.TVP.Module
{
    /// <summary>
    /// 主视图工具栏视图模型
    /// </summary>
    public class MainViewToolbarViewModel : VIZ.Framework.Core.ViewModelBase, IProjectSupport
    {
        public MainViewToolbarViewModel()
        {
            // 初始化命令
            this.initCommand();

            // 初始化控制器
            this.initController();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void initCommand()
        {
            this.CreateProjectCommand = new VCommand(this.CreateProject);
            this.OpenProjectCommand = new VCommand(this.OpenProject);
            this.SaveProjectCommand = new VCommand(this.SaveProject, this.CanSaveProject);
            this.SaveAsProjectCommand = new VCommand(this.SaveAsProject, this.CanSaveProject);
            this.CloseProjectCommand = new VCommand(this.CloseProject, this.CanSaveProject);

            this.SettingCommand = new VCommand(this.Setting);
        }

        /// <summary>
        /// 初始化控制器
        /// </summary>
        private void initController()
        {
            this.projectController = new ProjectController(this);
        }

        /// <summary>
        /// 项目控制器
        /// </summary>
        private ProjectController projectController;

        #region CreateProjectCommand -- 创建项目命令

        /// <summary>
        /// 创建项目命令
        /// </summary>
        public VCommand CreateProjectCommand { get; set; }

        /// <summary>
        /// 创建项目
        /// </summary>
        private void CreateProject()
        {
            this.projectController.CreateProject();
        }

        #endregion

        #region OpenProjectCommand -- 打开项目命令

        /// <summary>
        /// 打开项目命令
        /// </summary>
        public VCommand OpenProjectCommand { get; set; }

        /// <summary>
        /// 打开项目
        /// </summary>
        private void OpenProject()
        {
            this.projectController.OpenProject();
        }

        #endregion

        #region SaveProjectCommand -- 保存项目命令

        /// <summary>
        /// 保存项目命令
        /// </summary>
        public VCommand SaveProjectCommand { get; set; }

        /// <summary>
        /// 是否可以执行保存项目命令
        /// </summary>
        /// <returns>是否可以执行保存项目命令</returns>
        private bool CanSaveProject()
        {
            return ApplicationDomainEx.CurrentProjectDomain != null;
        }

        /// <summary>
        /// 保存项目
        /// </summary>
        private void SaveProject()
        {
            this.projectController.SaveProject();
        }

        #endregion

        #region SaveAsProjectCommand -- 另存为命令

        /// <summary>
        /// 另存为命令
        /// </summary>
        public VCommand SaveAsProjectCommand { get; set; }

        /// <summary>
        /// 另存为
        /// </summary>
        private void SaveAsProject()
        {
            this.projectController.SaveAsProject();
        }

        #endregion

        #region CloseProjectCommand -- 关闭项目命令

        /// <summary>
        /// 关闭项目命令
        /// </summary>
        public VCommand CloseProjectCommand { get; set; }

        /// <summary>
        /// 关闭项目
        /// </summary>
        private void CloseProject()
        {
            this.projectController.CloseProject();
        }

        #endregion

        #region SettingCommand -- 设置命令

        /// <summary>
        /// 设置命令
        /// </summary>
        public VCommand SettingCommand { get; set; }

        /// <summary>
        /// 设置
        /// </summary>
        private void Setting()
        {
            SettingWindow window = new SettingWindow();
            window.Owner = this.GetWindow();
            window.ShowDialog();
        }

        #endregion

        /// <summary>
        /// 更新命令状态
        /// </summary>
        public void UpdateCommandStatus()
        {
            this.SaveProjectCommand.RaiseCanExecute();
            this.SaveAsProjectCommand.RaiseCanExecute();
            this.CloseProjectCommand.RaiseCanExecute();
        }
    }
}
