﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Core;
using VIZ.Framework.Plugin;
using VIZ.TVP.Domain;

namespace VIZ.TVP.Module
{
    /// <summary>
    /// 节目单项创建视图模型
    /// </summary>
    public class ProgramItemCreateViewModel : ViewModelBase
    {
        public ProgramItemCreateViewModel()
        {
            // 初始化命令
            this.initCommand();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void initCommand()
        {
            this.EnterCommand = new VCommand(this.Enter);
            this.CancelCommand = new VCommand(this.Cancel);
        }

        // ===========================================================
        // Property
        // ===========================================================

        #region Scene -- 场景

        private string scene;
        /// <summary>
        /// 场景
        /// </summary>
        public string Scene
        {
            get { return scene; }
            set { scene = value; this.RaisePropertyChanged(nameof(Scene)); }
        }

        #endregion

        #region Remark -- 备注

        private string remark;
        /// <summary>
        /// 备注
        /// </summary>
        public string Remark
        {
            get { return remark; }
            set { remark = value; this.RaisePropertyChanged(nameof(Remark)); }
        }

        #endregion

        #region Layer -- 层

        private string layer;
        /// <summary>
        /// 层
        /// </summary>
        public string Layer
        {
            get { return layer; }
            set { layer = value; this.RaisePropertyChanged(nameof(Layer)); }
        }

        #endregion

        #region TemplatePlugins -- 模板插件集合

        private List<PluginInfo> templatePlugins;
        /// <summary>
        /// 模板插件集合
        /// </summary>
        public List<PluginInfo> TemplatePlugins
        {
            get { return templatePlugins; }
            set { templatePlugins = value; this.RaisePropertyChanged(nameof(TemplatePlugins)); }
        }

        #endregion

        #region SelectedTemplatePlugin -- 选中的模板插件

        private PluginInfo selectedTemplatePlugin;
        /// <summary>
        /// 选中的模板插件
        /// </summary>
        public PluginInfo SelectedTemplatePlugin
        {
            get { return selectedTemplatePlugin; }
            set { selectedTemplatePlugin = value; this.RaisePropertyChanged(nameof(SelectedTemplatePlugin)); }
        }

        #endregion

        // ===========================================================
        // Command
        // ===========================================================

        #region EnterCommand -- 确定命令

        /// <summary>
        /// 确定命令
        /// </summary>
        public VCommand EnterCommand { get; set; }

        /// <summary>
        /// 确定
        /// </summary>
        private void Enter()
        {
            Window window = this.GetWindow();
            if (window == null)
                return;

            window.DialogResult = true;

            window.Close();
        }

        #endregion

        #region CancelCommand -- 取消命令

        /// <summary>
        /// 取消命令
        /// </summary>
        public VCommand CancelCommand { get; set; }

        /// <summary>
        /// 取消
        /// </summary>
        private void Cancel()
        {
            Window window = this.GetWindow();
            if (window == null)
                return;

            window.DialogResult = false;

            window.Close();
        }

        #endregion

        // ===========================================================
        // Public Function
        // ===========================================================

        /// <summary>
        /// 初始化属性
        /// </summary>
        /// <param name="model">节目单项模型</param>
        public void InitPropertys(ProgramListItemModel model)
        {
            // 基础属性
            this.Scene = model.SceneName;
            this.Remark = model.Remark;
            this.Layer = model.Layer;

            // 插件
            this.TemplatePlugins = ApplicationDomainEx.PluginManager.TemplatePlugins;
            // TODO: 匹配插件
        }

        /// <summary>
        /// 更新节目单项模型属性
        /// </summary>
        /// <param name="model">节目单项模</param>
        public void UpdateProgramListItemModel(ProgramListItemModel model)
        {
            model.Remark = this.Remark;
            model.Layer = this.Layer;
            model.PluginID = this.SelectedTemplatePlugin?.ID;
            model.PluginName = this.SelectedTemplatePlugin?.DisplayName;
        }
    }
}
