﻿using DevExpress.Mvvm.Xpf;
using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Shapes;
using VIZ.Framework.Core;
using VIZ.Framework.Plugin;
using VIZ.TVP.Domain;
using VIZ.TVP.Service;
using VIZ.TVP.Storage;

namespace VIZ.TVP.Module
{
    /// <summary>
    /// 本地资源视图模型
    /// </summary>
    public class LocalResourceViewModel : PluginViewModelBase
    {


        /// <summary>
        /// 日志
        /// </summary>
        private static readonly ILog log = LogManager.GetLogger(typeof(VizResourceViewModel));



        public LocalResourceViewModel()
        {
            // 初始化控制器
           // this.initController();

            // 初始化命令
            this.initCommand();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void initCommand()
        {
            this.LoadedCommand = new VCommand(this.Loaded);
            this.RefreshFolderCommand = new VCommand(this.RefreshFolder);
            this.RefreshFileCommand = new VCommand(this.RefreshFile);
            this.FolderExpandCommand = new VCommand<DevExpress.Xpf.Grid.TreeList.NodeDoubleClickEventArgs>(this.FolderExpand);
            this.FileFilterCommand = new VCommand<ResourceFileType>(this.FileFilter);
            this.FileRowFilterCommand = new DevExpress.Mvvm.DelegateCommand<RowFilterArgs>(this.FileRowFilter);

            this.FileContextMenuOpendCommand = new VCommand(this.FileContextMenuOpend);
            this.AddProgramTemplateCommand = new VCommand(this.AddProgramTemplate, this.CanAddProgramTemplate);
        }

        /// <summary>
        /// 初始化控制器
        /// </summary>
        //private void initController()
        //{
        //    this.vizResourceFileController = new VizResourceFileController(this);
        //}

        // ==================================================================================
        // Property
        // ==================================================================================

        #region FolderModels -- 文件夹目录集合

        private ObservableCollection<GHResourceFolderModel> folderModels;
        /// <summary>
        /// 文件夹目录集合
        /// </summary>
        public ObservableCollection<GHResourceFolderModel> FolderModels
        {
            get { return folderModels; }
            set { folderModels = value; this.RaisePropertyChanged(nameof(FolderModels)); }
        }

        #endregion

        #region SelectedFolderModel -- 当前选中的文件夹

        private GHResourceFolderModel selectedFolderModel;
        /// <summary>
        /// 当前选中的文件夹
        /// </summary>
        public GHResourceFolderModel SelectedFolderModel
        {
            get { return selectedFolderModel; }
            set
            {
                selectedFolderModel = value;
                this.RaisePropertyChanged(nameof(SelectedFolderModel));
                // 更新文件模型
               // this.vizResourceFileController.UpdateFileModels(value);
            }
        }

        #endregion

        #region FileModels -- 文件集合

        private ObservableCollection<GHResourceFileModel> fileModels;
        /// <summary>
        /// 文件集合
        /// </summary>
        public ObservableCollection<GHResourceFileModel> FileModels
        {
            get { return fileModels; }
            set { fileModels = value; this.RaisePropertyChanged(nameof(FileModels)); }
        }

        #endregion

        #region SelectedFileModel -- 选中的文件模型

        private GHResourceFileModel selectedFileModel;
        /// <summary>
        /// 选中的文件模型
        /// </summary>
        public GHResourceFileModel SelectedFileModel
        {
            get { return selectedFileModel; }
            set { selectedFileModel = value; this.RaisePropertyChanged(nameof(SelectedFileModel)); }
        }

        #endregion

        #region IsFolderLoading -- 是否正在加载文件夹

        private bool isFolderLoading;
        /// <summary>
        /// 是否正在加载文件夹
        /// </summary>
        public bool IsFolderLoading
        {
            get { return isFolderLoading; }
            set { isFolderLoading = value; this.RaisePropertyChanged(nameof(IsFolderLoading)); }
        }

        #endregion

        #region IsFileLoading -- 是否正在加载文件

        private bool isFileLoading;
        /// <summary>
        /// 是否正在加载文件
        /// </summary>
        public bool IsFileLoading
        {
            get { return isFileLoading; }
            set { isFileLoading = value; this.RaisePropertyChanged(nameof(IsFileLoading)); }
        }

        #endregion

        #region FilterResourceFileType -- 资源文件类型

        private ResourceFileType filterResourceFileType;
        /// <summary>
        /// 资源文件类型
        /// </summary>
        public ResourceFileType FilterResourceFileType
        {
            get { return filterResourceFileType; }
            set { filterResourceFileType = value; this.RaisePropertySaveChanged(nameof(FilterResourceFileType)); }
        }

        #endregion

        // ==================================================================================
        // Service & Controller
        // ==================================================================================

        /// <summary>
        /// GH 资源服务
        /// </summary>
        private IGHResourceService ghResourceService = new GHResourceService();

        /// <summary>
        /// VIZ资源文件控制器
        /// </summary>
        private VizResourceFileController vizResourceFileController;

        // ==================================================================================
        // Command
        // ==================================================================================

        #region LoadedCommand -- 加载命令

        /// <summary>
        /// 加载命令
        /// </summary>
        public VCommand LoadedCommand { get; set; }

        /// <summary>
        /// 加载
        /// </summary>
        private void Loaded()
        {
            if (this.IsAlreadyLoaded)
                return;

            this.IsFolderLoading = true;

            // 刷新文件夹
            this.RefreshFolder();

            this.IsAlreadyLoaded = true;
        }

        #endregion

        #region RefreshFolderCommand -- 刷新文件夹命令

        /// <summary>
        /// 刷新文件夹命令
        /// </summary>
        public VCommand RefreshFolderCommand { get; set; }

        /// <summary>
        /// 刷新文件夹
        /// </summary>
        private void RefreshFolder()
        {
            this.IsFolderLoading = true;

            Task.Run(() =>
            {
                try
                {
                    //LocalInfoEntity info = ApplicationDomainEx.DataBaseManager.LocalInfo;

                    //string url = $"http://{info.GH_IP}:{info.GH_Port}/folders/";
                    //List<GHResourceFolderModel> list = this.ghResourceService.GetGHResourceFolders(url, null);

                    //WPFHelper.BeginInvoke(() =>
                    //{
                    //    this.FolderModels = list.FirstOrDefault()?.Children.Select(p => (GHResourceFolderModel)p).ToObservableCollection();

                    //    this.IsFolderLoading = false;
                    //});

                    // 获取电脑上的每个逻辑驱动器

                    this.FolderModels = new ObservableCollection<GHResourceFolderModel>();
                    foreach (var drive in Directory.GetLogicalDrives())
                    {
                        // 为此创建一个新项目
                        //var item = new TreeViewItem()
                        //{
                        //    // 设置标题
                        //    Header = drive,

                        //    // 完整路径
                        //    Tag = drive
                        //};


                        FolderModels.Add(new GHResourceFolderModel()
                        {
                            Name = drive,
                            Path = drive.ToString()
                        });



                        // 添加一个虚拟磁盘
                        //item.Items.Add(null);

                        // 监听正在扩展的文件
                        // item.Expanded += Folder_Expanded;

                        // 将其添加到主树视图
                        // FolderView.Items.Add(item);
                    }



                }
                catch (Exception ex)
                {
                    log.Error(ex);
                }
            });
        }


        private void Folder_Expanded(object sender, RoutedEventArgs e)
        {
            #region Initial Checks
            var item = (TreeViewItem)sender;

            // 如果项目仅包含伪数据,就返回
            if (item.Items.Count != 1 || item.Items[0] != null)
                return;

            // 清除数据
            item.Items.Clear();

            // 获取完整路径
            var fullPath = (String)item.Tag;

            #endregion

            #region Get Folders

            // 为目录创建一个空白列表
            var directories = new List<String>();


            // 尝试从文件夹中获取目录 // try异常处理,忽略出现的任何问题          
            try
            {
                var dirs = Directory.GetDirectories(fullPath);
                {
                    if (dirs.Length > 0)
                        directories.AddRange(dirs);
                }
            }
            catch { }

            // 为目录做迭代,添加目录
            directories.ForEach(directoryPath =>
            {
                // 创建目录项

                selectedFolderModel.Children = new ObservableCollection<ResourceFolderModelBase>();
                //var subItem = new TreeViewItem()
                //{
                //    // 将标题设置为文件夹名称
                //    Header = GetFileFolderName(directoryPath),
                //    // 标记为完整路径
                //    Tag = directoryPath
                //};

                //// 添加虚拟项目，以便我们可以扩展文件夹
                //subItem.Items.Add(null);
                //// 处理扩展
                //subItem.Expanded += Folder_Expanded;
                //// 将此项目添加到父项
                //item.Items.Add(subItem);

                //selectedFolderModel.Children.Add(new ResourceFolderModelBase()
                //{
                //    Name = GetFileFolderName(directoryPath),
                //    Path = directoryPath
                //});



            });
            #endregion

            #region Get Files
            // 为目录创建一个空白文件
            var Files = new List<String>();


            // 尝试从文件夹中获取文件 // try异常处理,忽略出现的任何问题          
            try
            {
                var fs = Directory.GetFiles(fullPath);
                {
                    if (fs.Length > 0)
                        Files.AddRange(fs);
                }
            }
            catch { }

            // 为目录做迭代,添加文件
            Files.ForEach(filePath =>
            {
                // 创建文件
                var subItem = new TreeViewItem()
                {
                    // 将标题设置为文件名称
                    Header = GetFileFolderName(filePath),
                    // 标记为完整路径
                    Tag = filePath
                };

                // 将此项目添加到父项
                item.Items.Add(subItem);
            });

            #endregion
        }

        #endregion

        /// <summary>
        /// 从完整路径中查找文件或文件夹名称
        /// </summary>
        /// <param name="path">完整路径</param>
        /// <returns></returns>
        public static string GetFileFolderName(string path)
        {
            // 如果没有路径，则返回空
            if (string.IsNullOrEmpty(path))
                return string.Empty;

            // 使所有斜杠成反斜杠
            var normalizedPath = path.Replace('/', '\\');

            // 找到最后一个反斜杠就是路径
            var lastIndex = normalizedPath.LastIndexOf('\\');

            // 如果找不到反斜线，则返回路径本身
            if (lastIndex <= 0)
                return path;

            // 最后一个反斜杠后返回名称
            return path.Substring(lastIndex + 1);
        }



        #region RefreshFileCommand -- 刷新文件命令

        /// <summary>
        /// 刷新文件命令
        /// </summary>
        public VCommand RefreshFileCommand { get; set; }

        /// <summary>
        /// 刷新文件
        /// </summary>
        private void RefreshFile()
        {
            GHResourceFolderModel folder = this.SelectedFolderModel;

            if (folder == null)
                return;

            this.vizResourceFileController.DisposeFileModels(folder);

            folder.IsRefreshedFiles = false;

            this.vizResourceFileController.UpdateFileModels(this.SelectedFolderModel);
        }

        #endregion

        #region FolderExpandCommand -- 文件夹展开命令

        /// <summary>
        /// 文件夹展开命令
        /// </summary>
        public VCommand<DevExpress.Xpf.Grid.TreeList.NodeDoubleClickEventArgs> FolderExpandCommand { get; set; }

        /// <summary>
        /// 文件夹展开
        /// </summary>
        private void FolderExpand(DevExpress.Xpf.Grid.TreeList.NodeDoubleClickEventArgs e)
        {
            //if (this.SelectedFolderModel == null || e.ChangedButton != System.Windows.Input.MouseButton.Left)
            //    return;

            //this.SelectedFolderModel.IsExpand = !this.SelectedFolderModel.IsExpand;


            #region Initial Checks
           // var item = (TreeViewItem)sender;

            //// 如果项目仅包含伪数据,就返回
            //if (item.Items.Count != 1 || item.Items[0] != null)
            //    return;

            //// 清除数据
            //item.Items.Clear();

            // 获取完整路径
            var fullPath = selectedFolderModel.Path;

            #endregion

            #region Get Folders

            // 为目录创建一个空白列表
            var directories = new List<String>();


            // 尝试从文件夹中获取目录 // try异常处理,忽略出现的任何问题          
            try
            {
                var dirs = Directory.GetDirectories(fullPath);
                {
                    if (dirs.Length > 0)
                        directories.AddRange(dirs);
                }
            }
            catch { }

            // 为目录做迭代,添加目录
            //directories.ForEach(directoryPath =>
            //{
            //    // 创建目录项
            //    var subItem = new TreeViewItem()
            //    {
            //        // 将标题设置为文件夹名称
            //        Header = GetFileFolderName(directoryPath),
            //        // 标记为完整路径
            //        Tag = directoryPath
            //    };

            //    // 添加虚拟项目，以便我们可以扩展文件夹
            //    subItem.Items.Add(null);
            //    // 处理扩展
            //    subItem.Expanded += Folder_Expanded;
            //    // 将此项目添加到父项
            //    item.Items.Add(subItem);




            //});
            #endregion

            #region Get Files
            // 为目录创建一个空白文件
            var Files = new List<String>();


            // 尝试从文件夹中获取文件 // try异常处理,忽略出现的任何问题          
            try
            {
                var fs = Directory.GetFiles(fullPath);
                {
                    if (fs.Length > 0)
                        Files.AddRange(fs);
                }
            }
            catch { }

            // 为目录做迭代,添加文件
            //Files.ForEach(filePath =>
            //{
            //    // 创建文件
            //    var subItem = new TreeViewItem()
            //    {
            //        // 将标题设置为文件名称
            //        Header = GetFileFolderName(filePath),
            //        // 标记为完整路径
            //        Tag = filePath
            //    };

            //    // 将此项目添加到父项
            //    item.Items.Add(subItem);
            //});

            #endregion


        }

        #endregion

        #region FileFilterCommand -- 文件过滤命令

        /// <summary>
        /// 文件过滤命令
        /// </summary>
        public VCommand<ResourceFileType> FileFilterCommand { get; set; }

        /// <summary>
        /// 文件过滤
        /// </summary>
        /// <param name="type"></param>
        private void FileFilter(ResourceFileType type)
        {
            this.FilterResourceFileType = type;

            VizResourceView view = this.GetView<VizResourceView>();
            if (view == null)
                return;

            view.fileGrid.RefreshData();
        }

        #endregion

        #region FileContextMenuOpendCommand -- 文件右键菜单打开命令

        /// <summary>
        /// 文件右键菜单打开命令
        /// </summary>
        public VCommand FileContextMenuOpendCommand { get; set; }

        /// <summary>
        /// 文件右键菜单打开
        /// </summary>
        private void FileContextMenuOpend()
        {
            this.AddProgramTemplateCommand.RaiseCanExecute();
        }

        #endregion

        #region AddProgramTemplateCommand -- 添加节目模板命令

        /// <summary>
        /// 添加节目模板命令
        /// </summary>
        public VCommand AddProgramTemplateCommand { get; set; }

        /// <summary>
        /// 是否可以执行添加节目模板
        /// </summary>
        /// <returns>是否可以执行添加节目模板</returns>
        private bool CanAddProgramTemplate()
        {
            return this.SelectedFileModel != null && this.SelectedFileModel.FileType == ResourceFileType.SCENE && ApplicationDomainEx.CurrentProjectDomain != null;
        }

        /// <summary>
        /// 添加节目模板
        /// </summary>
        private void AddProgramTemplate()
        {
            if (this.SelectedFileModel == null || this.SelectedFileModel.FileType != ResourceFileType.SCENE)
                return;

            IProgramListViewService service = ApplicationDomainEx.ServiceManager.GetService<IProgramListViewService>(ServiceKeys.PROGRAM_LIST_VIEW_SERVICE);
            if (service == null)
                return;

            service.AddSceneTemplate(this.SelectedFileModel);
        }

        #endregion

        #region FileRowFilterCommand -- 文件行筛选命令

        /// <summary>
        /// 文件行筛选命令, 该命令必须使用Dev的命令基类
        /// </summary>
        public DevExpress.Mvvm.DelegateCommand<RowFilterArgs> FileRowFilterCommand { get; set; }

        /// <summary>
        /// 文件行筛选
        /// </summary>
        /// <param name="e">赛选参数</param>
        private void FileRowFilter(RowFilterArgs e)
        {
            GHResourceFileModel fileModel = e.Item as GHResourceFileModel;
            if (fileModel == null)
            {
                e.Visible = false;
                return;
            }

            if (this.FilterResourceFileType == ResourceFileType.None)
            {
                e.Visible = true;
                return;
            }

            e.Visible = fileModel.FileType == this.FilterResourceFileType;
        }

        #endregion

        // ==================================================================================
        // Public Function
        // ==================================================================================

        /// <summary>
        /// 销毁
        /// </summary>
        public override void Dispose()
        {

        }

    }
}
