﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.TVP.Domain;
using VIZ.TVP.Storage;

namespace VIZ.TVP.Service
{
    /// <summary>
    /// VIZ命令ControlObject服务
    /// </summary>
    public interface IVizCommandControlObjectService
    {
        /// <summary>
        /// 获取场景树节点信息
        /// </summary>
        /// <param name="connection">连接</param>
        /// <param name="layer">场景图层</param>
        /// <returns>场景树节点信息</returns>
        List<VizTreeNodeInfo> GetTreeNodeList(TVPConnectionModel connection, VizSceneLayerEnum layer);

        /// <summary>
        /// 获取控制对象列表
        /// </summary>
        /// <param name="connection">连接</param>
        /// <param name="layer">场景图层</param>
        /// <returns>控制对象列表</returns>
        List<VizControlObjectModel> GetControlObjectList(TVPConnectionModel connection, VizSceneLayerEnum layer);
    }
}