﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using VIZ.Framework.Core;

namespace VIZ.TVP.Storage
{
    /// <summary>
    /// GH 缩略图节点
    /// </summary>
    public class GH_Thumbnail_Node : IXmlSerialize
    {
        /// <summary>
        /// 地址
        /// </summary>
        public string url { get; set; }

        /// <summary>
        /// 宽度
        /// </summary>
        public string width { get; set; }

        /// <summary>
        /// 高度
        /// </summary>
        public string height { get; set; }

        /// <summary>
        /// 从XElement节点获取数据
        /// </summary>
        /// <param name="element">XElement节点</param>
        public void FromXmlElement(XElement element)
        {
            if (element == null)
                return;

            this.url = element.GetAttributeValue<string>("url");
            this.width = element.GetAttributeValue<string>("width");
            this.height = element.GetAttributeValue<string>("height");
        }
    }
}
