﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;

namespace VIZ.TVP.Storage
{
    /// <summary>
    /// GH Entry 节点
    /// </summary>
    public class GH_Entry_Node : IXmlSerialize
    {
        /// <summary>
        /// 编号
        /// </summary>
        public string id { get; set; }

        /// <summary>
        /// 标题
        /// </summary>
        public string title { get; set; }

        /// <summary>
        /// 更新时间
        /// </summary>
        public string updated { get; set; }

        /// <summary>
        /// 分类集合
        /// </summary>
        public List<GH_Category_Node> categorys { get; set; } = new List<GH_Category_Node>();

        /// <summary>
        /// 连接集合
        /// </summary>
        public List<GH_Link_Node> links { get; set; } = new List<GH_Link_Node>();

        /// <summary>
        /// 内容
        /// </summary>
        public GH_Content_Node content { get; set; } = new GH_Content_Node();

        /// <summary>
        /// 缩略图
        /// </summary>
        public GH_Thumbnail_Node thumbnail { get; set; } = new GH_Thumbnail_Node();

        /// <summary>
        /// 从XElement节点获取数据
        /// </summary>
        /// <param name="element">XElement节点</param>
        public void FromXmlElement(XElement element)
        {
            if (element == null)
                return;

            this.title = element.Element(XName.Get("title", GH_Xmlns_Enums.xmlns))?.Value;
            this.id = element.Element(XName.Get("id", GH_Xmlns_Enums.xmlns))?.Value;
            this.updated = element.Element(XName.Get("updated_at", GH_Xmlns_Enums.xmlns))?.Value;

            // 分类
            foreach (XElement category in element.Elements(XName.Get("category", GH_Xmlns_Enums.xmlns)))
            {
                GH_Category_Node category_node = new GH_Category_Node();
                category_node.FromXmlElement(category);

                this.categorys.Add(category_node);
            }

            // 连接
            foreach (XElement link in element.Elements(XName.Get("link", GH_Xmlns_Enums.xmlns)))
            {
                GH_Link_Node link_node = new GH_Link_Node();
                link_node.FromXmlElement(link);

                this.links.Add(link_node);
            }

            // 内容
            this.content.FromXmlElement(element.Element(XName.Get("content", GH_Xmlns_Enums.xmlns)));
            // 缩略图
            this.thumbnail.FromXmlElement(element.Element(XName.Get("thumbnail", GH_Xmlns_Enums.media)));
        }
    }
}
