﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.TVP.Storage;

namespace VIZ.TVP.Domain
{
    /// <summary>
    /// 节目模板模型
    /// </summary>
    public class ProgramTemplateModel : ModelBase
    {
        /// <summary>
        /// 节目模板模型
        /// </summary>
        /// <param name="entity">界面模板实体</param>
        public ProgramTemplateModel(ProgramTemplateEntity entity)
        {
            this.Entity = entity;
        }

        /// <summary>
        /// 实体
        /// </summary>
        public ProgramTemplateEntity Entity { get; private set; }

        #region TemplateID -- 模板ID

        private string templateID;
        /// <summary>
        /// 模板ID
        /// </summary>
        public string TemplateID
        {
            get { return templateID; }
            set { templateID = value; this.RaisePropertyChanged(nameof(TemplateID)); }
        }

        #endregion

        #region TemplateType -- 模板类型

        private ProgramTemplateType templateType;
        /// <summary>
        /// 模板类型
        /// </summary>
        public ProgramTemplateType TemplateType
        {
            get { return templateType; }
            set { templateType = value; this.RaisePropertyChanged(nameof(TemplateType)); }
        }

        #endregion

        #region SceneName -- 场景名

        private string sceneName;
        /// <summary>
        /// 场景名
        /// </summary>
        public string SceneName
        {
            get { return sceneName; }
            set { sceneName = value; this.RaisePropertyChanged(nameof(SceneName)); }
        }

        #endregion

        #region Thumbnail -- 缩略图

        private string thumbnail;
        /// <summary>
        /// 缩略图
        /// </summary>
        public string Thumbnail
        {
            get { return thumbnail; }
            set { thumbnail = value; this.RaisePropertyChanged(nameof(Thumbnail)); }
        }

        #endregion

        #region Remark -- 备注

        private string remark;
        /// <summary>
        /// 备注
        /// </summary>
        public string Remark
        {
            get { return remark; }
            set { remark = value; this.RaisePropertyChanged(nameof(Remark)); }
        }

        #endregion

        #region Layer -- 层

        private string layer;
        /// <summary>
        /// 层
        /// </summary>
        public string Layer
        {
            get { return layer; }
            set { layer = value; this.RaisePropertyChanged(nameof(Layer)); }
        }

        #endregion

        #region EngineType -- 引擎类型

        private TVPEngineType engineType;
        /// <summary>
        /// 引擎类型
        /// </summary>
        public TVPEngineType EngineType
        {
            get { return engineType; }
            set { engineType = value; this.RaisePropertyChanged(nameof(EngineType)); }
        }

        #endregion

        #region OrderIndex -- 排序索引

        private int orderIndex;
        /// <summary>
        /// 排序索引
        /// </summary>
        public int OrderIndex
        {
            get { return orderIndex; }
            set { orderIndex = value; this.RaisePropertyChanged(nameof(OrderIndex)); }
        }

        #endregion

        // ---------------------------------------------------------------------
        // 扩展属性

        #region ThumbnailBitmap -- 缩略图图片

        private Bitmap thumbnailBitmap;
        /// <summary>
        /// 缩略图图片
        /// </summary>
        public Bitmap ThumbnailBitmap
        {
            get { return thumbnailBitmap; }
            set { thumbnailBitmap = value; this.RaisePropertyChanged(nameof(ThumbnailBitmap)); }
        }

        #endregion

        /// <summary>
        /// 从实体中获取属性
        /// </summary>
        public void PropertyFromEntity()
        {
            this.TemplateID = this.Entity.TemplateID;
            this.TemplateType = this.Entity.TemplateType;
            this.SceneName = this.Entity.SceneName;
            this.Thumbnail = this.Entity.Thumbnail;
            this.Remark = this.Entity.Remark;
            this.Layer = this.Entity.Layer;
            this.EngineType = this.Entity.EngineType;
            this.OrderIndex = this.Entity.OrderIndex;
        }

        /// <summary>
        /// 将属性填充至实体
        /// </summary>
        public void PropertyToEntity()
        {
            this.Entity.TemplateID = this.TemplateID;
            this.Entity.TemplateType = this.TemplateType;
            this.Entity.SceneName = this.SceneName;
            this.Entity.Thumbnail = this.Thumbnail;
            this.Entity.Remark = this.Remark;
            this.Entity.Layer = this.Layer;
            this.Entity.EngineType = this.EngineType;
            this.Entity.OrderIndex = this.OrderIndex;
        }
    }
}
