﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.TVP.Domain;
using VIZ.TVP.Storage;

namespace VIZ.TVP.Module
{
    /// <summary>
    /// 登录控制器
    /// </summary>
    public class LoginController
    {
        /// <summary>
        /// 登录控制器
        /// </summary>
        /// <param name="support">支持</param>
        public LoginController(ILoginSupport support)
        {
            this.Support = support;
        }


        /// <summary>
        /// 支持
        /// </summary>
        public ILoginSupport Support { get; private set; }

        /// <summary>
        /// 加载登录信息
        /// </summary>
        public void LoadedLoginInfo()
        {
            LocalInfoEntity info = ApplicationDomainEx.DataBaseManager.LiteDbContext.LocalInfo.FindAll().FirstOrDefault();
            if (info == null)
            {
                info = new LocalInfoEntity();

                ApplicationDomainEx.DataBaseManager.LiteDbContext.LocalInfo.Upsert(info);
            }

            this.Support.GH_IP = info.GH_IP;
            this.Support.GH_Port = info.GH_Port;
            this.Support.GH_ServerName = info.GH_ServerName;
            this.Support.VIZ_UserName = info.VIZ_UserName;
            this.Support.VIZ_Password = info.VIZ_Password;
            this.Support.SelectedLocalEngineType = this.Support.LocalEngineTypes.FirstOrDefault(p => (LocalEngineType)p.Key == info.LocalEngineType) ?? this.Support.LocalEngineTypes.FirstOrDefault();

            ApplicationDomainEx.DataBaseManager.LocalInfo = info;
        }

        /// <summary>
        /// 登录
        /// </summary>
        /// <returns>是否成功执行登录</returns>
        public bool Login()
        {
            LocalInfoEntity info = ApplicationDomainEx.DataBaseManager.LocalInfo;

            info.GH_IP = this.Support.GH_IP;
            info.GH_Port = this.Support.GH_Port;
            info.GH_ServerName = this.Support.GH_ServerName;
            info.VIZ_UserName = this.Support.VIZ_UserName;
            info.VIZ_Password = this.Support.VIZ_Password;
            info.LocalEngineType = (LocalEngineType)this.Support.SelectedLocalEngineType.Key;

            ApplicationDomainEx.DataBaseManager.LiteDbContext.LocalInfo.Update(info);

            return true;
        }
    }
}
