﻿using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Core;
using VIZ.TVP.Domain;
using VIZ.TVP.Storage;

namespace VIZ.TVP.Module
{
    /// <summary>
    /// 登录视图模型
    /// </summary>
    public class LoginViewModel : ViewModelBase, ILoginSupport, IPluginSupport
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static readonly ILog log = LogManager.GetLogger(typeof(LoginViewModel));

        public LoginViewModel()
        {
            // 初始化命令
            this.initCommand();

            // 初始化控制器
            this.initController();

            // 初始化属性
            this.initProperty();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void initCommand()
        {
            this.LoadedCommand = new VCommand(this.Loaded);
            this.LoginCommand = new VCommand(this.Login);
        }

        /// <summary>
        /// 初始化控制器
        /// </summary>
        private void initController()
        {
            this.loginController = new LoginController(this);
            this.pluginController = new PluginController(this);
        }

        /// <summary>
        /// 初始化属性
        /// </summary>
        private void initProperty()
        {
            this.LocalEngineTypes = EnumHelper.GetEnumModels<LocalEngineType>();
        }

        // ==================================================================================
        // Property
        // ==================================================================================

        #region GH_IP -- GH IP

        private string gh_ip;
        /// <summary>
        /// GH_IP
        /// </summary>
        public string GH_IP
        {
            get { return gh_ip; }
            set { gh_ip = value; this.RaisePropertyChanged(nameof(GH_IP)); }
        }


        #endregion

        #region GH_Port -- GH 端口

        private int gh_port;
        /// <summary>
        /// GH 端口
        /// </summary>
        public int GH_Port
        {
            get { return gh_port; }
            set { gh_port = value; this.RaisePropertyChanged(nameof(GH_Port)); }
        }

        #endregion

        #region GH_ServerName -- GH 服务名

        private string gh_serverName;
        /// <summary>
        /// GH 服务名
        /// </summary>
        public string GH_ServerName
        {
            get { return gh_serverName; }
            set { gh_serverName = value; this.RaisePropertyChanged(nameof(GH_ServerName)); }
        }

        #endregion

        #region VIZ_UserName -- VIZ 用户名

        private string viz_userName;
        /// <summary>
        /// VIZ 用户名
        /// </summary>
        public string VIZ_UserName
        {
            get { return viz_userName; }
            set { viz_userName = value; this.RaisePropertyChanged(nameof(VIZ_UserName)); }
        }

        #endregion

        #region VIZ_Password -- VIZ 密码

        private string viz_password;
        /// <summary>
        /// VIZ 密码
        /// </summary>
        public string VIZ_Password
        {
            get { return viz_password; }
            set { viz_password = value; this.RaisePropertyChanged(nameof(VIZ_Password)); }
        }

        #endregion

        #region LocalEngineTypes -- 本机引擎类型集合

        private List<EnumModel> localEngineTypes;
        /// <summary>
        /// 本机引擎类型集合
        /// </summary>
        public List<EnumModel> LocalEngineTypes
        {
            get { return localEngineTypes; }
            set { localEngineTypes = value; this.RaisePropertyChanged(nameof(LocalEngineTypes)); }
        }

        #endregion

        #region SelectedLocalEngineType -- 当前选择的引擎类型

        private EnumModel selectedLocalEngineType;
        /// <summary>
        /// 当前选择的引擎类型
        /// </summary>
        public EnumModel SelectedLocalEngineType
        {
            get { return selectedLocalEngineType; }
            set { selectedLocalEngineType = value; this.RaisePropertyChanged(nameof(SelectedLocalEngineType)); }
        }

        #endregion

        #region IsLoading -- 是否正在等待

        private bool isLoading;
        /// <summary>
        /// 是否正在等待
        /// </summary>
        public bool IsLoading
        {
            get { return isLoading; }
            set { isLoading = value; this.RaisePropertyChanged(nameof(IsLoading)); }
        }

        #endregion

        // ==================================================================================
        // Controller
        // ==================================================================================

        /// <summary>
        /// 登录控制器
        /// </summary>
        private LoginController loginController;

        /// <summary>
        /// 插件控制器
        /// </summary>
        private PluginController pluginController;

        // ==================================================================================
        // Command
        // ==================================================================================

        #region LoadedCommand -- 加载命令

        /// <summary>
        /// 加载命令
        /// </summary>
        public VCommand LoadedCommand { get; set; }

        /// <summary>
        /// 加载
        /// </summary>
        private void Loaded()
        {
            this.IsLoading = true;

            ThreadHelper.SafeRun(() =>
            {
                // 加载登录信息
                this.loginController.LoadedLoginInfo();

                // 加载插件
                this.pluginController.LoadPlugins();

                WPFHelper.BeginInvoke(() =>
                {
                    this.IsLoading = false;
                });
            });
        }

        #endregion

        #region LoginCommand -- 登录命令

        /// <summary>
        /// 登录命令
        /// </summary>
        public VCommand LoginCommand { get; set; }

        /// <summary>
        /// 登录
        /// </summary>
        private void Login()
        {
            // 执行登录流程
            if (!this.loginController.Login())
                return;

            // 成功登录
            Window loginWindow = this.GetWindow();
            loginWindow.ShowInTaskbar = false;
            ApplicationDomainEx.WindowManager.MainWindow = ApplicationDomainEx.WindowManager.MainWindowType.Assembly.CreateInstance(ApplicationDomainEx.WindowManager.MainWindowType.FullName) as Window;
            ApplicationDomainEx.WindowManager.MainWindow.Show();
            loginWindow.Hide();
        }

        #endregion
    }
}
