﻿using DevExpress.Mvvm.Native;
using log4net;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.TVP.Connection;
using VIZ.TVP.Domain;
using VIZ.TVP.Storage;
using static DevExpress.Xpf.Core.HandleDecorator.Helpers.NativeMethods;

namespace VIZ.TVP.Module
{
    /// <summary>
    /// VIZ控制器
    /// </summary>
    public class VizController
    {
        /// <summary>
        /// 日志
        /// </summary>
        private readonly static ILog log = LogManager.GetLogger(typeof(VizController));

        /// <summary>
        /// VIZ控制器
        /// </summary>
        /// <param name="support">支持</param>
        public VizController(IVizSupport support)
        {
            this.Support = support;
        }

        /// <summary>
        /// 支持
        /// </summary>
        public IVizSupport Support { get; private set; }

        /// <summary>
        /// VIZ进程
        /// </summary>
        public Process VizProcess { get; private set; }

        /// <summary>
        /// 启动VIZ引擎
        /// </summary>
        /// <param name="view"></param>
        /// <param name="config">引擎配置</param>
        /// <param name="connectionModel">连接模型</param>
        public void StartVizEngine(VizRenderView view, TVPEngineConfig config, TVPConnectionModel connectionModel)
        {
            this.Support.IsEngineReady = false;

            var dpi = WPFHelper.GetDpiByGraphics();
            int width = (int)(view.host.ActualWidth * (dpi.X / 96d));
            int height = (int)(view.host.ActualHeight * (dpi.Y / 96d));
            IntPtr hWnd = view.host.ContainerFormHandle;
            IntPtr vizHandle = IntPtr.Zero;

            ThreadHelper.SafeRun(() =>
            {
                // Step 1. 启动进程
                this.VizProcess = new Process();
                this.VizProcess.StartInfo.WorkingDirectory = System.IO.Path.GetDirectoryName(config.FullPath);
                this.VizProcess.StartInfo.FileName = System.IO.Path.GetFileName(config.FullPath);
                // " -o -P -db Guest:@localhost/VizDbServer:19396"
                LocalInfoEntity loginInfo = ApplicationDomainEx.DataBaseManager.LocalInfo;
                this.VizProcess.StartInfo.Arguments = $" -o -P -db {loginInfo.GH_UserName}:@{loginInfo.GH_IP}/{loginInfo.GH_ServerName}:{loginInfo.GH_Port}";
                this.VizProcess.StartInfo.UseShellExecute = true;
                this.VizProcess.StartInfo.WindowStyle = ProcessWindowStyle.Normal;
                this.VizProcess.Start();

                // Step 2. 连接VIZ
                do
                {
                    System.Threading.Thread.Sleep(1000);

                } while (!connectionModel.EndpointManager.Connect());

                // Step 3. 发送渲染命令
                do
                {
                    System.Threading.Thread.Sleep(1000);

                    string cmd = $"RENDERER WINDOW_OPEN_ON_PARENT 0x{hWnd.ToString("X6")} {width} {height} ONAIR";
                    connectionModel.EndpointManager.Send(cmd);

                    WPFHelper.Invoke(() =>
                    {
                        vizHandle = view.host.TargetWindowHandle;
                    });

                } while (vizHandle == IntPtr.Zero);
            });
        }
    }
}
