﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Framework.Plugin;
using VIZ.TVP.Connection;
using VIZ.TVP.Domain;
using VIZ.TVP.Storage;
using static VIZ.Framework.Core.WPFHelper;

namespace VIZ.TVP.Module
{
    /// <summary>
    /// VIZ渲染视图模型
    /// </summary>
    public class VizRenderViewModel : PluginViewModelBase, IVizSupport
    {
        public VizRenderViewModel()
        {
            // 初始化控制器
            this.initController();

            // 初始化命令
            this.initCommand();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void initCommand()
        {
            this.LoadedCommand = new VCommand(this.Loaded);
            this.WindowHostSizeChangedCommand = new VCommand<System.Windows.SizeChangedEventArgs>(this.WindowHostSizeChanged);

            this.TestCommand = new VCommand(this.Test);
        }

        /// <summary>
        /// 初始化控制器
        /// </summary>
        private void initController()
        {
            this.vizController = new VizController(this);
        }

        // ================================================================================
        // Property
        // ================================================================================

        #region IsEngineReady -- 引擎是否准备完毕

        private bool isEngineReady;
        /// <summary>
        /// 引擎是否准备完毕
        /// </summary>
        public bool IsEngineReady
        {
            get { return isEngineReady; }
            set { isEngineReady = value; this.RaisePropertyChanged(nameof(IsEngineReady)); }
        }

        #endregion


        // ================================================================================
        // Controller
        // ================================================================================

        /// <summary>
        /// Viz控制器
        /// </summary>
        private VizController vizController;

        // ================================================================================
        // Command
        // ================================================================================

        #region LoadedCommand -- 加载命令

        /// <summary>
        /// 加载命令
        /// </summary>
        public VCommand LoadedCommand { get; set; }

        /// <summary>
        /// 加载
        /// </summary>
        private void Loaded()
        {
            if (this.IsAlreadyLoaded)
                return;

            VizRenderView view = this.GetView<VizRenderView>();

            this.IsAlreadyLoaded = true;
        }

        #endregion

        #region WindowHostSizeChangedCommand -- 宿主容器大小改变命令

        /// <summary>
        /// 宿主容器大小改变命令
        /// </summary>
        public VCommand<System.Windows.SizeChangedEventArgs> WindowHostSizeChangedCommand { get; set; }

        /// <summary>
        /// 宿主容器大小改变
        /// </summary>
        private void WindowHostSizeChanged(System.Windows.SizeChangedEventArgs e)
        {
            if (this.connectionModel == null || !this.connectionModel.IsConnected)
                return;

            var dpi = WPFHelper.GetDpiByGraphics();

            int width = (int)(e.NewSize.Width * (dpi.X / 96d));
            int height = (int)(e.NewSize.Height * (dpi.Y / 96d));
            this.connectionModel.EndpointManager.Send($"RENDERER WINDOW_RESIZE {width} {height}");
        }

        #endregion

        #region TestCommand -- 测试命令

        /// <summary>
        /// 测试命令
        /// </summary>
        public VCommand TestCommand { get; set; }

        /// <summary>
        /// 测试
        /// </summary>
        private void Test()
        {
            VizRenderView view = this.GetView<VizRenderView>();

            // --------------------------------------------------------------------
            // 测试代码
            // --------------------------------------------------------------------
            //TVPEngineConfig config = new TVPEngineConfig();
            //config.Name = "测试VIZ引擎";
            //config.EngineType = TVPEngineType.VIZ;
            //config.FullPath = @"D:\Program Files (x86)\Vizrt\Viz3\viz.exe";
            ////config.FullPath = @"C:\Program Files\Vizrt\Viz3\viz.exe";

            //// --------------------------------------------------------------------

            //// Step 2. 等待发送命令
            //this.connectionModel = new TVPConnectionModel();
            //connectionModel.ID = "test";
            //connectionModel.InitEndpointManager(new VizEndpointManager("test", "localhost", 6100));

            //this.vizController.StartVizEngine(view, config, this.connectionModel);

        }

        private TVPConnectionModel connectionModel;

        #endregion

        // ================================================================================
        // Public Function
        // ================================================================================

        /// <summary>
        /// 销毁
        /// </summary>
        public override void Dispose()
        {

        }
    }
}
