﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.TVP.Domain;
using VIZ.TVP.Storage;

namespace VIZ.TVP.Service
{
    /// <summary>
    /// GH 资源服务
    /// </summary>
    public class GHResourceService : IGHResourceService
    {
        /// <summary>
        /// GH服务
        /// </summary>
        private IGHService ghService = new GHService();

        /// <summary>
        /// 获取GH资源文件夹
        /// </summary>
        /// <param name="url">GH请求地址</param>
        /// <returns>GH资源树根节点</returns>
        public List<GHResourceFolderModel> GetGHResourceFolders(string url)
        {
            List<GHResourceFolderModel> list = new List<GHResourceFolderModel>();

            GH_Feed_Node feed_node = ghService.GetFeedNode(url);

            foreach (GH_Entry_Node entry_node in feed_node.entries)
            {
                GHResourceFolderModel child = new GHResourceFolderModel();
                child.EntryNode = entry_node;

                // 名称
                child.Name = entry_node.title;

                // 类型
                if (entry_node.categorys.Any(p => p.term == GH_Category_Term_Enums.Project))
                {
                    child.FolderType = ResourceFolderType.Project;
                }
                if (entry_node.categorys.Any(p => p.term == GH_Category_Term_Enums.Folder))
                {
                    child.FolderType = ResourceFolderType.Folder;
                }

                // 子项信息
                GH_Link_Node link_down = entry_node.links.FirstOrDefault(p => p.rel == GH_Link_Rel_Enums.down);
                if (link_down == null)
                    continue;

                List<GHResourceFolderModel> child_list = this.GetGHResourceFolders(link_down.href);

                foreach (GHResourceFolderModel item in child_list)
                {
                    child.Children.Add(item);
                    item.Parent = child;
                }

                list.Add(child);
            }

            return list;
        }

        /// <summary>
        /// 获取GH资源文件
        /// </summary>
        /// <param name="url">GH请求地址</param>
        /// <returns>GH资源文件</returns>
        public List<GHResourceFileModel> GetGHResourceFiles(string url)
        {
            List<GHResourceFileModel> list = new List<GHResourceFileModel>();

            GH_Feed_Node feed_node = ghService.GetFeedNode(url);

            foreach (GH_Entry_Node entry_node in feed_node.entries)
            {
                GHResourceFileModel child = new GHResourceFileModel();
                child.EntryNode = entry_node;

                // 名称
                child.Name = entry_node.title;
                child.Src = entry_node.content.src;
                child.Thumbnail = entry_node.thumbnail.url;
                child.MimeType = entry_node.content.type;

                // 图片
                if (entry_node.categorys.Any(p => p.term == GH_Category_Term_Enums.IMAGE))
                {
                    child.FileType = ResourceFileType.IMAGE;
                }

                // 场景
                if (entry_node.categorys.Any(p => p.term == GH_Category_Term_Enums.SCENE))
                {
                    child.FileType = ResourceFileType.SCENE;
                }

                list.Add(child);
            }

            return list;
        }
    }
}
